/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.hibernate.SessionFactory;
import org.opensingular.flow.persistence.service.FlowRetrieveService;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.context.singleton.SpringBoundedSingletonStrategy;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.opensingular.lib.support.spring.util.AutoScanDisabled;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableTransactionManagement(proxyTargetClass=true)
@EnableCaching
@EnableWebMvc
@EnableWebSecurity
@ComponentScan(basePackages={"org.opensingular", "com.opensingular"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={AutoScanDisabled.class})})
public class SingularServerSpringAppConfig
implements Loggable {
    @Inject
    ApplicationContextProvider applicationContextProvider;

    @PostConstruct
    public void init() {
        this.getLogger().info("initializing Singular-Spring configuration");
        SingularServerSpringAppConfig singularServerSpringAppConfig = this;
        this.getLogger().info("ApplicationContextProvider configured:" + singularServerSpringAppConfig.applicationContextProvider.isConfigured());
    }

    @Order(value=1)
    @Bean
    @Lazy(value=false)
    public SpringBoundedSingletonStrategy springBoundedSingletonStrategy() {
        return new SpringBoundedSingletonStrategy();
    }

    @Bean
    public FlowRetrieveService getProcessRetrieveService(SessionFactory sessionFactory) {
        FlowRetrieveService flowRetrieveService = new FlowRetrieveService();
        flowRetrieveService.setSessionLocator(() -> ((SessionFactory)sessionFactory).getCurrentSession());
        return flowRetrieveService;
    }
}

