/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.flow.persistence.entity.Actor;
import org.opensingular.form.context.SFormConfig;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.server.commons.box.action.BoxItemActionList;
import org.opensingular.server.commons.form.FormAction;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.service.RequirementService;
import org.opensingular.server.commons.service.dto.BoxConfigurationData;
import org.opensingular.server.commons.service.dto.BoxItemAction;
import org.opensingular.server.commons.service.dto.FormDTO;
import org.opensingular.server.commons.spring.security.PermissionResolverService;
import org.opensingular.server.commons.spring.security.RequirementAuthMetadataDTO;
import org.opensingular.server.commons.spring.security.SingularPermission;
import org.opensingular.server.commons.spring.security.SingularUserDetailsService;
import org.opensingular.server.commons.wicket.SingularSession;

public class AuthorizationService
implements Loggable {
    public static final String LIST_TASKS_PERMISSION_PREFIX = "LIST_TASKS";
    public static final String SEPARATOR = "|$|";
    @Inject
    protected PermissionResolverService permissionResolverService;
    @Inject
    protected RequirementService<RequirementEntity, RequirementInstance> requirementService;
    @Inject
    @Named(value="peticionamentoUserDetailService")
    private SingularUserDetailsService peticionamentoUserDetailService;
    @Inject
    @Named(value="formConfigWithDatabase")
    private Optional<SFormConfig<String>> singularFormConfig;

    public void filterBoxWithPermissions(List<BoxConfigurationData> groupDTOs, String idUsuario) {
        List<SingularPermission> permissions = this.searchPermissions(idUsuario);
        Iterator<BoxConfigurationData> it = groupDTOs.iterator();
        while (it.hasNext()) {
            BoxConfigurationData boxConfigurationMetadata = it.next();
            String permissionNeeded = boxConfigurationMetadata.getId().toUpperCase();
            if (!this.hasPermission(idUsuario, permissionNeeded, permissions)) {
                it.remove();
                continue;
            }
            this.filterForms(boxConfigurationMetadata, permissions, idUsuario);
        }
    }

    public void filterActions(String formType, Long requirementId, BoxItemActionList actions, String idUsuario) {
        List<SingularPermission> permissions = this.searchPermissions(idUsuario);
        this.filterActions(formType, requirementId, actions, idUsuario, permissions);
    }

    private void filterActions(String formType, Long requirementId, BoxItemActionList actions, String idUsuario, List<SingularPermission> permissions) {
        RequirementAuthMetadataDTO requirementAuthMetadataDTO = null;
        if (requirementId != null) {
            requirementAuthMetadataDTO = this.requirementService.findRequirementAuthMetadata(requirementId);
        }
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            BoxItemAction action = (BoxItemAction)it.next();
            String typeAbbreviation = this.getFormSimpleName(formType);
            String permissionsNeeded = action.getFormAction() != null ? this.buildPermissionKey(requirementAuthMetadataDTO, typeAbbreviation, action.getFormAction().name()) : this.buildPermissionKey(requirementAuthMetadataDTO, typeAbbreviation, action.getName());
            if (this.hasPermission(idUsuario, permissionsNeeded, permissions)) continue;
            it.remove();
        }
    }

    public void filterActors(List<Actor> actors, Long requirementId, String actionName) {
        RequirementAuthMetadataDTO requirementAuthMetadataDTO = this.requirementService.findRequirementAuthMetadata(requirementId);
        if (actors != null && !actors.isEmpty()) {
            actors.removeIf(a -> !this.hasPermission(requirementAuthMetadataDTO, null, a.getCodUsuario(), actionName));
        }
    }

    public List<SingularPermission> filterListTaskPermissions(List<SingularPermission> permissions) {
        return permissions.stream().filter(p -> p != null && p.getSingularId() != null && p.getSingularId().startsWith(LIST_TASKS_PERMISSION_PREFIX)).collect(Collectors.toList());
    }

    private List<SingularPermission> searchPermissions(String userPermissionKey) {
        Object userDetails;
        if (SingularSession.exists() && userPermissionKey.equals((userDetails = SingularSession.get().getUserDetails()).getUserPermissionKey())) {
            if (CollectionUtils.isEmpty(userDetails.getPermissions())) {
                userDetails.addPermissions(this.peticionamentoUserDetailService.searchPermissions((String)userDetails.getUserPermissionKey()));
            }
            return userDetails.getPermissions();
        }
        return this.permissionResolverService.searchPermissions(userPermissionKey);
    }

    private void filterForms(BoxConfigurationData boxConfigurationMetadata, List<SingularPermission> permissions, String idUsuario) {
        Iterator<FormDTO> it = boxConfigurationMetadata.getForms().iterator();
        while (it.hasNext()) {
            FormDTO form = it.next();
            String permissionNeeded = this.buildPermissionKey(null, form.getAbbreviation(), FormAction.FORM_FILL.name());
            if (this.hasPermission(idUsuario, permissionNeeded, permissions)) continue;
            it.remove();
        }
    }

    private String buildPermissionKey(RequirementAuthMetadataDTO requirementAuthMetadataDTO, String formSimpleName, String action) {
        String permission = Joiner.on((String)SEPARATOR).skipNulls().join((Object)this.upperCaseOrNull(action), (Object)this.upperCaseOrNull(formSimpleName), new Object[]{this.getDefinitionKey(requirementAuthMetadataDTO), this.getCurrentTaskAbbreviation(requirementAuthMetadataDTO)}).toUpperCase();
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().debug(String.format("Nome de permiss\u00e3o computada %s", permission));
        }
        return permission;
    }

    private String getDefinitionKey(RequirementAuthMetadataDTO requirementAuthMetadataDTO) {
        if (requirementAuthMetadataDTO != null) {
            return requirementAuthMetadataDTO.getDefinitionKey();
        }
        return null;
    }

    private String getCurrentTaskAbbreviation(RequirementAuthMetadataDTO requirementAuthMetadataDTO) {
        if (requirementAuthMetadataDTO != null) {
            return requirementAuthMetadataDTO.getCurrentTaskAbbreviation();
        }
        return null;
    }

    private String upperCaseOrNull(String string) {
        if (string != null) {
            return string.toUpperCase();
        }
        return null;
    }

    public boolean hasPermission(Long requirementId, String formType, String idUsuario, String action) {
        RequirementAuthMetadataDTO requirementAuthMetadataDTO = null;
        if (requirementId != null) {
            requirementAuthMetadataDTO = this.requirementService.findRequirementAuthMetadata(requirementId);
        }
        return this.hasPermission(requirementAuthMetadataDTO, formType, idUsuario, action);
    }

    private boolean hasPermission(RequirementAuthMetadataDTO requirementAuthMetadataDTO, String formType, String idUsuario, String action) {
        String formSimpleName = this.getFormSimpleName(formType);
        if (requirementAuthMetadataDTO != null) {
            formSimpleName = this.getFormSimpleName(requirementAuthMetadataDTO.getFormTypeAbbreviation());
        }
        return this.hasPermission(idUsuario, this.buildPermissionKey(requirementAuthMetadataDTO, formSimpleName, action));
    }

    private boolean hasPermission(String idUsuario, String permissionNeeded) {
        List<SingularPermission> permissions = this.searchPermissions(idUsuario);
        return this.hasPermission(idUsuario, permissionNeeded, permissions);
    }

    private String removeTask(String permissionId) {
        int idx = permissionId.lastIndexOf(SEPARATOR);
        if (idx > -1) {
            return permissionId.substring(0, idx);
        }
        return permissionId;
    }

    private boolean hasPermission(String idUsuario, String permissionNeeded, List<SingularPermission> permissions) {
        if (SingularProperties.get().isTrue("singular.auth.disable")) {
            return true;
        }
        if (permissions.stream().anyMatch(ps -> ps.getSingularId().equals(permissionNeeded))) {
            return true;
        }
        String definitionPermission = this.removeTask(permissionNeeded);
        if (permissions.stream().anyMatch(ps -> ps.getSingularId().equals(definitionPermission))) {
            return true;
        }
        this.getLogger().info(" Usu\u00e1rio logado {} n\u00e3o possui a permiss\u00e3o {} ", (Object)idUsuario, (Object)permissionNeeded);
        return false;
    }

    private String getFormSimpleName(String formTypeName) {
        if (StringUtils.isBlank((CharSequence)formTypeName)) {
            return null;
        }
        return this.singularFormConfig.flatMap(formConfig -> formConfig.getTypeLoader().loadType((Serializable)((Object)formTypeName))).map(type -> type.getNameSimple()).map(String::toUpperCase).orElse(null);
    }
}

