/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.opensingular.flow.core.SUser;
import org.opensingular.flow.persistence.entity.Actor;
import org.opensingular.server.commons.config.IServerContext;
import org.opensingular.server.commons.config.SingularServerConfiguration;
import org.opensingular.server.commons.persistence.dao.flow.ActorDAO;
import org.opensingular.server.commons.spring.security.DefaultUserDetails;
import org.opensingular.server.commons.spring.security.SingularPermission;
import org.opensingular.server.commons.spring.security.SingularUserDetails;
import org.opensingular.server.commons.spring.security.SingularUserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class DefaultUserDetailService
implements SingularUserDetailsService {
    @Inject
    private ActorDAO actorDAO;
    @Inject
    private SingularServerConfiguration singularServerConfiguration;

    @Override
    public SingularUserDetails loadUserByUsername(String username, IServerContext context) throws UsernameNotFoundException {
        Actor user = this.actorDAO.retrieveByUserCod(username);
        return new DefaultUserDetails(username, new ArrayList<SingularPermission>(), Optional.ofNullable(user).map(SUser::getSimpleName).orElse(username), context);
    }

    @Override
    public IServerContext[] getContexts() {
        return this.singularServerConfiguration.getContexts();
    }

    @Override
    public List<SingularPermission> searchPermissions(String idUsuarioLogado) {
        return Collections.emptyList();
    }
}

