/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensingular.flow.core.Flow;
import org.opensingular.flow.core.FlowDefinition;
import org.opensingular.flow.core.SingularFlowConfigurationBean;
import org.opensingular.form.SFormUtil;
import org.opensingular.lib.commons.base.SingularUtil;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.server.commons.cache.SingularCacheForever;
import org.opensingular.server.commons.cache.SingularSessionCache;
import org.opensingular.server.commons.config.SingularServerConfiguration;
import org.opensingular.server.commons.form.FormAction;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.service.RequirementService;
import org.opensingular.server.commons.spring.security.SingularPermission;
import org.opensingular.server.commons.spring.security.SingularUserDetailsService;

public class PermissionResolverService
implements Loggable {
    @Inject
    protected RequirementService<RequirementEntity, RequirementInstance> requirementService;
    @Inject
    @Named(value="peticionamentoUserDetailService")
    private SingularUserDetailsService peticionamentoUserDetailService;
    @Inject
    private SingularServerConfiguration singularServerConfiguration;
    @Inject
    private Optional<SingularFlowConfigurationBean> singularFlowConfigurationBean;

    @SingularSessionCache
    public List<SingularPermission> searchPermissions(String idUsuario) {
        return this.peticionamentoUserDetailService.searchPermissions(idUsuario);
    }

    @SingularCacheForever
    public List<? extends SingularPermission> listAllCategoryPermissions() {
        return Flow.getDefinitions().stream().map(d -> this.buildCategoryPermission(d.getCategory())).distinct().collect(Collectors.toList());
    }

    @SingularCacheForever
    public List<? extends SingularPermission> listAllTypePermissions() {
        ArrayList<SingularPermission> permissions = new ArrayList<SingularPermission>();
        List<String> typeNames = this.listAllTypeNames();
        for (String typeName : typeNames) {
            for (FormAction action : FormAction.values()) {
                String singularId = (Object)((Object)action) + "_" + typeName;
                permissions.add(new SingularPermission(singularId, null));
            }
        }
        return permissions;
    }

    @SingularCacheForever
    private List<String> listAllTypeNames() {
        return this.singularServerConfiguration.getFormTypes().stream().map(clazz -> SFormUtil.getTypeSimpleName((Class)clazz).get().toUpperCase()).collect(Collectors.toList());
    }

    @SingularCacheForever
    public List<? extends SingularPermission> listAllProcessesPermissions() {
        ArrayList<? extends SingularPermission> permissions = new ArrayList<SingularPermission>();
        if (this.singularFlowConfigurationBean.isPresent()) {
            for (FlowDefinition pd : this.singularFlowConfigurationBean.get().getDefinitions()) {
                permissions.addAll(this.listPermissions(pd.getClass()));
            }
        }
        return permissions;
    }

    @SingularCacheForever
    private List<? extends SingularPermission> listPermissions(Class<? extends FlowDefinition> clazz) {
        return Collections.emptyList();
    }

    public SingularPermission buildCategoryPermission(String cateogryName) {
        return new SingularPermission("BOX_" + SingularUtil.normalize((String)cateogryName).toUpperCase(), null);
    }

    private SingularPermission buildActionPermission(String actionName, String processName) {
        String singularId = "ACTION_" + actionName + "_" + processName;
        singularId = singularId.toUpperCase();
        return new SingularPermission(singularId, null);
    }
}

