/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security;

import java.io.Serializable;
import java.util.Optional;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.opensingular.server.commons.util.url.UrlToolkit;
import org.opensingular.server.commons.util.url.UrlToolkitBuilder;

public class SecurityAuthPaths
implements Serializable {
    private final String urlPath;
    private final String contextPath;
    private final UrlToolkitBuilder urlToolkitBuilder;

    public SecurityAuthPaths(String contextPath, String urlPath, UrlToolkitBuilder urlToolkitBuilder) {
        this.urlPath = urlPath;
        this.contextPath = contextPath;
        this.urlToolkitBuilder = urlToolkitBuilder;
    }

    public String getLoginPath() {
        return this.contextPath + this.urlPath + "/login";
    }

    public String getLogoutPath(RequestCycle requestCycle) {
        String baseUrl = this.contextPath + this.urlPath + "/logout";
        if (requestCycle != null) {
            baseUrl = this.mountLogoutPathWithRequectCycle(requestCycle, baseUrl);
        }
        return baseUrl;
    }

    private String mountLogoutPathWithRequectCycle(RequestCycle requestCycle, String baseUrl) {
        Request request = requestCycle.getRequest();
        Url url = request.getUrl();
        UrlToolkit urlToolkit = this.urlToolkitBuilder.build(url);
        Optional<String> filterPath = Optional.ofNullable(request.getFilterPath());
        String logoutPath = urlToolkit.concatServerAdressWithContext(baseUrl);
        logoutPath = logoutPath + "?service=" + urlToolkit.concatServerAdressWithContext(this.contextPath + filterPath.orElse(""));
        return logoutPath;
    }
}

