/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opensingular.server.commons.config.IServerContext;
import org.opensingular.server.commons.spring.security.SingularPermission;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public interface SingularUserDetails
extends UserDetails {
    default public boolean isContext(IServerContext context) {
        return context.equals(this.getServerContext());
    }

    public Object getUserPermissionKey();

    public IServerContext getServerContext();

    public String getDisplayName();

    public List<SingularPermission> getPermissions();

    default public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.emptyList();
    }

    default public String getPassword() {
        return null;
    }

    public void addPermission(SingularPermission var1);

    default public void addPermissions(SingularPermission ... roles) {
        this.addPermissions(Arrays.asList(roles));
    }

    default public void addPermissions(List<SingularPermission> roles) {
        if (roles != null) {
            for (SingularPermission role : roles) {
                this.addPermission(role);
            }
        }
    }

    default public boolean isAccountNonExpired() {
        return true;
    }

    default public boolean isAccountNonLocked() {
        return true;
    }

    default public boolean isCredentialsNonExpired() {
        return true;
    }

    default public boolean isEnabled() {
        return true;
    }

    default public String getUserId() {
        return null;
    }

    default public boolean keepLoginThroughContexts() {
        return false;
    }
}

