/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.opensingular.server.commons.config.IServerContext;
import org.opensingular.server.commons.spring.security.SingularPermission;
import org.opensingular.server.commons.spring.security.SingularUserDetails;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Transactional
public interface SingularUserDetailsService
extends UserDetailsService,
UserDetailsContextMapper {
    default public SingularUserDetails mapUserFromContext(DirContextOperations dirContextOperations, String s, Collection<? extends GrantedAuthority> collection) {
        return this.loadUserByUsername(s);
    }

    default public void mapUserToContext(UserDetails userDetails, DirContextAdapter dirContextAdapter) {
    }

    default public SingularUserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        return this.loadUserByUsername(username, IServerContext.getContextFromRequest(request, this.getContexts()));
    }

    public SingularUserDetails loadUserByUsername(String var1, IServerContext var2) throws UsernameNotFoundException;

    public IServerContext[] getContexts();

    public List<SingularPermission> searchPermissions(String var1);
}

