/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security.config;

import java.util.Optional;
import javax.inject.Inject;
import org.opensingular.lib.support.spring.util.AutoScanDisabled;
import org.opensingular.server.commons.auth.AdminCredentialChecker;
import org.opensingular.server.commons.auth.AdministrationAuthenticationProvider;
import org.opensingular.server.commons.config.IServerContext;
import org.opensingular.server.commons.config.PServerContext;
import org.opensingular.server.commons.spring.security.config.cas.SingularCASSpringSecurityConfig;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

public class SecurityConfigs {

    @Configuration
    @EnableWebMvc
    @Order(value=105)
    @AutoScanDisabled
    public static class AdministrationSecurity
    extends WebSecurityConfigurerAdapter {
        @Inject
        private Optional<AdminCredentialChecker> credentialChecker;

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.regexMatcher(PServerContext.ADMINISTRATION.getPathRegex()).authorizeRequests().anyRequest()).authenticated().and()).csrf().disable()).httpBasic();
        }

        protected void configure(AuthenticationManagerBuilder auth) throws Exception {
            this.credentialChecker.ifPresent(cc -> auth.authenticationProvider((AuthenticationProvider)new AdministrationAuthenticationProvider((AdminCredentialChecker)cc, PServerContext.ADMINISTRATION)));
        }
    }

    @Configuration
    @EnableWebMvc
    @Order(value=104)
    @AutoScanDisabled
    public static class CASAnalise
    extends SingularCASSpringSecurityConfig {
        @Override
        protected IServerContext getContext() {
            return PServerContext.WORKLIST;
        }

        @Override
        public String getCASLogoutURL() {
            return "";
        }
    }

    @Configuration
    @EnableWebMvc
    @Order(value=103)
    @AutoScanDisabled
    public static class CASPeticionamento
    extends SingularCASSpringSecurityConfig {
        @Override
        protected IServerContext getContext() {
            return PServerContext.REQUIREMENT;
        }

        @Override
        public String getCASLogoutURL() {
            return "";
        }
    }
}

