/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security.config.cas;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringEscapeUtils;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.server.commons.spring.security.config.SingularLogoutHandler;

public class SingularCASLogoutHandler
implements SingularLogoutHandler,
Loggable {
    private String logoutURL;

    public SingularCASLogoutHandler() {
    }

    public SingularCASLogoutHandler(String logoutURL) {
        this.logoutURL = logoutURL;
    }

    @Override
    public void handleLogout(HttpServletRequest req, HttpServletResponse resp) {
        HttpServletRequest request = req;
        HttpServletResponse response = resp;
        try {
            this.getLogger().warn(" CAPTURADA REQUEST DE LOGOUT EM : {}. A SESSAO DESSA APLICACAO SERA INVALIDADA E SERA FEITO O SINGLE SIGN OUT", (Object)StringEscapeUtils.escapeJava((String)request.getRequestURI()));
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            String redirect = this.logoutURL + "?service=" + URLEncoder.encode(this.extractServiceParam(request), StandardCharsets.UTF_8.name());
            this.getLogger().warn(" REDIRECIONANDO PARA: {}", (Object)StringEscapeUtils.escapeJava((String)redirect));
            response.sendRedirect(redirect);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            throw SingularException.rethrow((Throwable)e);
        }
    }

    private String extractServiceParam(HttpServletRequest request) {
        String service = request.getParameter("service");
        if (service == null || service.length() < 1) {
            String url = request.getRequestURL().toString();
            int index = url.lastIndexOf(request.getContextPath());
            service = url.substring(0, index) + request.getContextPath();
        }
        return service;
    }
}

