/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security.config.cas;

import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.spring.security.AbstractSingularSpringSecurityAdapter;
import org.opensingular.server.commons.spring.security.SingularUserDetailsService;
import org.opensingular.server.commons.spring.security.config.SingularLogoutHandler;
import org.opensingular.server.commons.spring.security.config.cas.SingularCASLogoutHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.preauth.j2ee.J2eePreAuthenticatedProcessingFilter;

public abstract class SingularCASSpringSecurityConfig
extends AbstractSingularSpringSecurityAdapter {
    @Inject
    @Named(value="peticionamentoUserDetailService")
    protected Optional<SingularUserDetailsService> peticionamentoUserDetailService;

    @Bean
    public SingularLogoutHandler singularLogoutHandler() {
        return new SingularCASLogoutHandler(this.getCASLogoutURL());
    }

    @Override
    public void configure(WebSecurity web) throws Exception {
        if (SingularProperties.get().isTrue("singular.development")) {
            // empty if block
        }
        super.configure(web);
    }

    public void configure(HttpSecurity http) throws Exception {
        PreAuthenticatedAuthenticationProvider casAuthenticationProvider = new PreAuthenticatedAuthenticationProvider();
        casAuthenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new UserDetailsByNameServiceWrapper((UserDetailsService)this.peticionamentoUserDetailService.orElseThrow(() -> SingularServerException.rethrow(String.format("Bean %s do tipo %s n\u00e3o pode ser nulo. Para utilizar a configura\u00e7\u00e3o de seguran\u00e7a %s \u00e9 preciso declarar um bean do tipo %s identificado pelo nome %s .", UserDetailsService.class.getName(), "peticionamentoUserDetailService", SingularCASSpringSecurityConfig.class.getName(), UserDetailsService.class.getName(), "peticionamentoUserDetailService")))));
        ProviderManager authenticationManager = new ProviderManager(Arrays.asList(casAuthenticationProvider));
        J2eePreAuthenticatedProcessingFilter j2eeFilter = new J2eePreAuthenticatedProcessingFilter();
        j2eeFilter.setAuthenticationManager((AuthenticationManager)authenticationManager);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.regexMatcher(this.getContext().getPathRegex()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)new Http403ForbiddenEntryPoint()).and()).csrf().disable()).headers().frameOptions().sameOrigin().and()).jee().j2eePreAuthenticatedProcessingFilter(j2eeFilter).and()).authorizeRequests().antMatchers(new String[]{this.getContext().getContextPath()})).authenticated();
    }

    public abstract String getCASLogoutURL();
}

