/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security.config.cas.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.server.commons.spring.security.config.cas.util.SSOConfigurableFilter;

public class AuthenticationFilterWrapper
extends SSOConfigurableFilter {
    private static final String DELEGATE_CLASS_NAME = "org.jasig.cas.client.authentication.AuthenticationFilter";
    private static final String CAS_SERVER_LOGIN_URL_PARAM = "casServerLoginUrl";
    private static final String SERVER_NAME_PARAM = "serverName";
    private static final String SERVICE_PARAM = "service";
    public static final String SERVICE_URL_PARAM = "serviceUrl";
    private Filter delegate = null;

    @Override
    public void init(final FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        final HashMap<String, String> params = new HashMap<String, String>();
        params.put(CAS_SERVER_LOGIN_URL_PARAM, SingularProperties.getOpt((String)this.getSingularContext().getServerPropertyKey("cas.login")).orElse(null));
        Optional<String> serviceUrl = this.resolveServiceUrl(filterConfig);
        if (serviceUrl.isPresent()) {
            params.put(SERVICE_PARAM, serviceUrl.get());
        } else {
            params.put(SERVER_NAME_PARAM, SingularProperties.getOpt((String)this.getSingularContext().getServerPropertyKey("cas.server.name")).orElse(null));
        }
        Enumeration enumeration = filterConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String s = (String)enumeration.nextElement();
            params.put(s, filterConfig.getInitParameter(s));
        }
        try {
            FilterConfig newConfig = new FilterConfig(){

                public ServletContext getServletContext() {
                    return filterConfig.getServletContext();
                }

                public Enumeration<String> getInitParameterNames() {
                    return Collections.enumeration(params.keySet());
                }

                public String getInitParameter(String name) {
                    return (String)params.get(name);
                }

                public String getFilterName() {
                    return filterConfig.getFilterName();
                }
            };
            this.delegate = (Filter)Class.forName(DELEGATE_CLASS_NAME).newInstance();
            this.delegate.init(newConfig);
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.delegate.doFilter(request, response, chain);
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public Optional<String> resolveServiceUrl(FilterConfig filterConfig) {
        String filterServiceURL = filterConfig.getInitParameter(SERVICE_URL_PARAM);
        if (filterServiceURL == null) {
            return SingularProperties.getOpt((String)this.getSingularContext().getServerPropertyKey("cas.service.url"));
        }
        return Optional.ofNullable(filterServiceURL);
    }
}

