/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security.config.cas.util;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.opensingular.server.commons.spring.security.config.cas.util.AuthenticationFilterWrapper;
import org.opensingular.server.commons.spring.security.config.cas.util.Cas30ProxyReceivingTicketValidationFilterWrapper;
import org.opensingular.server.commons.spring.security.config.cas.util.SSOConfigurableFilter;
import org.opensingular.server.commons.spring.security.config.cas.util.SSOLogoutUtil;
import org.opensingular.server.commons.spring.security.config.cas.util.SingleSingOutFilterWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOFilter
extends SSOConfigurableFilter {
    public static final String SSO_CLIENT_SERVER = "cas.server.name";
    public static final String SSO_URL_PREFIX = "cas.url.prefix";
    public static final String SSO_LOGOUT = "cas.logout";
    public static final String SSO_LOGIN = "cas.login";
    public static final String SERVICE_URL_PARAM = "cas.service.url";
    private static final Logger logger = LoggerFactory.getLogger(SSOFilter.class);
    public static final String URL_EXCLUDE_PATTERN_PARAM = "urlExcludePattern";
    public static final String CLIENT_LOGOUT_URL = "logoutUrl";
    Filter[] internalFilterChain = new Filter[]{new SingleSingOutFilterWrapper(), new AuthenticationFilterWrapper(), new Cas30ProxyReceivingTicketValidationFilterWrapper(), new HttpServletRequestWrapperFilter()};
    private String[] urlExcludePatterns = null;
    private String logoutUrl = "/logout";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (!Strings.isNullOrEmpty((String)filterConfig.getInitParameter(URL_EXCLUDE_PATTERN_PARAM))) {
            String urlExcludePattern = filterConfig.getInitParameter(URL_EXCLUDE_PATTERN_PARAM);
            this.urlExcludePatterns = urlExcludePattern.split(",");
        }
        if (!Strings.isNullOrEmpty((String)filterConfig.getInitParameter(CLIENT_LOGOUT_URL))) {
            this.logoutUrl = filterConfig.getInitParameter(CLIENT_LOGOUT_URL);
        }
        for (Filter f : this.internalFilterChain) {
            f.init(filterConfig);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        if (this.urlMatches(request, this.logoutUrl)) {
            SSOLogoutUtil.logout(request, (HttpServletResponse)response, this.getSingularContext());
        } else if (this.isURLExcluded(request)) {
            chain.doFilter((ServletRequest)request, response);
        } else {
            new VirtualFilterChain(chain, this.internalFilterChain).doFilter((ServletRequest)request, response);
        }
    }

    private boolean isURLExcluded(HttpServletRequest request) {
        if (this.urlExcludePatterns != null) {
            for (String urlExcludePattern : this.urlExcludePatterns) {
                if (!this.urlMatches(request, urlExcludePattern)) continue;
                logger.info("Filter skipped due to regex patterns defined in urlExcludePattern properties. URL: {} ", (Object)StringEscapeUtils.escapeJava((String)request.getRequestURL().toString()));
                return true;
            }
        }
        return false;
    }

    private boolean urlMatches(HttpServletRequest request, String path) {
        String url = request.getRequestURI();
        String contextPath = request.getContextPath();
        return (url = url.replaceFirst(contextPath, "")).matches(path);
    }

    public void destroy() {
        for (Filter f : this.internalFilterChain) {
            f.destroy();
        }
    }

    private static class VirtualFilterChain
    implements FilterChain {
        private final FilterChain originalChain;
        private final List<? extends Filter> additionalFilters;
        private int currentPosition = 0;

        private VirtualFilterChain(FilterChain chain, Filter[] additionalFilters) {
            this.originalChain = chain;
            this.additionalFilters = Arrays.asList(additionalFilters);
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.currentPosition == this.additionalFilters.size()) {
                this.originalChain.doFilter(request, response);
            } else {
                ++this.currentPosition;
                Filter nextFilter = this.additionalFilters.get(this.currentPosition - 1);
                nextFilter.doFilter(request, response, (FilterChain)this);
            }
        }
    }
}

