/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring.security.config.cas.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.server.commons.spring.security.config.cas.util.SSOConfigurableFilter;

public class SingleSingOutFilterWrapper
extends SSOConfigurableFilter {
    private static final String DELEGATE_CLASS_NAME = "org.jasig.cas.client.session.SingleSignOutFilter";
    private static final String CAS_SERVER_URL_PREFIX_PARAM = "casServerUrlPrefix";
    private Filter delegate = null;

    @Override
    public void init(final FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        final HashMap<String, String> params = new HashMap<String, String>();
        params.put(CAS_SERVER_URL_PREFIX_PARAM, SingularProperties.getOpt((String)this.getSingularContext().getServerPropertyKey("cas.url.prefix")).orElse(null));
        Enumeration enumeration = filterConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String s = (String)enumeration.nextElement();
            params.put(s, filterConfig.getInitParameter(s));
        }
        try {
            FilterConfig newConfig = new FilterConfig(){

                public ServletContext getServletContext() {
                    return filterConfig.getServletContext();
                }

                public Enumeration<String> getInitParameterNames() {
                    return Collections.enumeration(params.keySet());
                }

                public String getInitParameter(String name) {
                    return (String)params.get(name);
                }

                public String getFilterName() {
                    return filterConfig.getFilterName();
                }
            };
            this.delegate = (Filter)Class.forName(DELEGATE_CLASS_NAME).newInstance();
            this.delegate.init(newConfig);
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        this.delegate.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.delegate.doFilter(request, response, chain);
    }

    public void destroy() {
        this.delegate.destroy();
    }
}

