/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.test;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.server.commons.test.ContextUtil;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletWebRequest;

public class SingularServletContextTestExecutionListener
extends AbstractTestExecutionListener
implements Loggable {
    public void prepareTestInstance(TestContext testContext) throws Exception {
        this.setUpRequestContext(testContext);
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.setUpRequestContext(testContext);
    }

    private void setUpRequestContext(TestContext testContext) {
        ApplicationContext context = testContext.getApplicationContext();
        if (context instanceof WebApplicationContext) {
            WebApplicationContext wac = (WebApplicationContext)context;
            ServletContext servletContext = wac.getServletContext();
            MockServletContext mockServletContext = (MockServletContext)servletContext;
            MockHttpServletRequest request = new MockHttpServletRequest((ServletContext)mockServletContext);
            ContextUtil.prepareRequest((ServletRequest)request);
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletWebRequest servletWebRequest = new ServletWebRequest((HttpServletRequest)request, (HttpServletResponse)response);
            RequestContextHolder.setRequestAttributes((RequestAttributes)servletWebRequest);
            if (wac instanceof ConfigurableApplicationContext) {
                ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)wac;
                ConfigurableListableBeanFactory bf = configurableApplicationContext.getBeanFactory();
                bf.registerResolvableDependency(MockHttpServletResponse.class, (Object)response);
                bf.registerResolvableDependency(ServletWebRequest.class, (Object)servletWebRequest);
            }
        }
    }
}

