/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.opensingular.server.commons.test.ContextUtil;
import org.springframework.mock.web.MockHttpServletRequest;

public class SingularTestRequestCycleListener
extends AbstractRequestCycleListener {
    public void onBeginRequest(RequestCycle cycle) {
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)cycle.getRequest().getContainerRequest();
        HttpServletRequest superPoweredMockRequest = this.getSuperPoweredHttpRequest(mockHttpServletRequest);
        ServletWebRequest superPoweredRequest = this.getSuperPoweredRequest((ServletWebRequest)cycle.getRequest(), superPoweredMockRequest);
        cycle.setRequest((Request)superPoweredRequest);
        ContextUtil.prepareRequest((ServletRequest)superPoweredMockRequest);
    }

    private HttpServletRequest getSuperPoweredHttpRequest(final HttpServletRequest httpServletRequest) {
        if (this.isSuperPowered(httpServletRequest)) {
            return httpServletRequest;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(new Class[]{HttpServletRequest.class, SuperPoweredHttpServletRequest.class});
        enhancer.setCallback((Callback)new MethodInterceptor(){
            private String contextPath;
            private String pathInfo;

            public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws InvocationTargetException, IllegalAccessException {
                if ("setContextPath".equals(method.getName())) {
                    this.contextPath = (String)objects[0];
                    return null;
                }
                if ("getContextPath".equals(method.getName())) {
                    return this.contextPath;
                }
                if ("setPathInfo".equals(method.getName())) {
                    this.pathInfo = (String)objects[0];
                    return null;
                }
                if ("getPathInfo".equals(method.getName())) {
                    return this.pathInfo;
                }
                return method.invoke((Object)httpServletRequest, objects);
            }
        });
        return (HttpServletRequest)enhancer.create();
    }

    private ServletWebRequest getSuperPoweredRequest(final ServletWebRequest request, final HttpServletRequest superPoweredMockRequest) {
        if (this.isSuperPowered(request)) {
            return request;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(SingularServletWebRequest.class);
        enhancer.setInterfaces(new Class[]{SuperPowered.class});
        enhancer.setCallback((Callback)new InvocationHandler(){

            public Object invoke(Object o, Method method, Object[] objects) throws InvocationTargetException, IllegalAccessException {
                if ("getContainerRequest".equals(method.getName())) {
                    return superPoweredMockRequest;
                }
                return method.invoke((Object)request, objects);
            }
        });
        return (ServletWebRequest)enhancer.create();
    }

    public boolean isSuperPowered(Object o) {
        return o instanceof SuperPowered;
    }

    public static class SingularServletWebRequest
    extends ServletWebRequest {
        public SingularServletWebRequest() {
            super((HttpServletRequest)new MockHttpServletRequest(), "");
        }
    }

    public static interface SuperPoweredHttpServletRequest
    extends SuperPowered {
        public void setContextPath(String var1);

        public void setPathInfo(String var1);
    }

    public static interface SuperPowered {
    }
}

