/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.time.Duration;
import org.opensingular.internal.lib.wicket.test.WicketSerializationDebugUtil;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.opensingular.lib.wicket.util.application.SingularAnnotatedMountScanner;
import org.opensingular.lib.wicket.util.application.SkinnableApplication;
import org.opensingular.lib.wicket.util.page.error.Error403Page;
import org.opensingular.lib.wicket.util.template.admin.SingularAdminApp;
import org.opensingular.lib.wicket.util.template.admin.SingularAdminTemplate;
import org.opensingular.lib.wicket.util.util.WicketUtils;
import org.opensingular.server.commons.wicket.SingularSession;
import org.opensingular.server.commons.wicket.error.Page410;
import org.opensingular.server.commons.wicket.listener.SingularServerContextListener;
import org.opensingular.server.commons.wicket.view.behavior.SingularJSBehavior;
import org.opensingular.server.commons.wicket.view.template.Footer;
import org.opensingular.server.commons.wicket.view.template.Header;
import org.springframework.context.ApplicationContext;

public abstract class SingularServerApplication
extends AuthenticatedWebApplication
implements SkinnableApplication,
SingularAdminApp {
    public static SingularServerApplication get() {
        return (SingularServerApplication)WebApplication.get();
    }

    public void init() {
        super.init();
        this.getRequestCycleSettings().setTimeout(Duration.minutes((int)5));
        this.getRequestCycleListeners().add((Object)new SingularServerContextListener());
        Locale.setDefault(new Locale("pt", "BR"));
        this.getApplicationSettings().setAccessDeniedPage(Error403Page.class);
        this.getApplicationSettings().setPageExpiredErrorPage(Page410.class);
        this.getApplicationSettings().setDefaultMaximumUploadSize(Bytes.megabytes((long)10L));
        this.getMarkupSettings().setStripWicketTags(true);
        this.getMarkupSettings().setStripComments(true);
        this.getMarkupSettings().setDefaultMarkupEncoding(StandardCharsets.UTF_8.name());
        this.getComponentOnConfigureListeners().add(component -> {
            boolean outputId = !component.getRenderBodyOnly();
            component.setOutputMarkupId(outputId).setOutputMarkupPlaceholderTag(outputId);
        });
        this.getComponentInstantiationListeners().add((Object)new SpringComponentInjector((WebApplication)this, this.getApplicationContext(), true));
        new SingularAnnotatedMountScanner().mountPages((WebApplication)this);
        if (RuntimeConfigurationType.DEVELOPMENT == this.getConfigurationType()) {
            this.getDebugSettings().setComponentPathAttributeName("wicketdebug");
            WicketSerializationDebugUtil.configurePageSerializationDebug((Application)this, ((Object)((Object)this)).getClass());
        }
    }

    public Session newSession(Request request, Response response) {
        return new SingularSession(request, response);
    }

    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return SingularSession.class;
    }

    protected Class<? extends WebPage> getSignInPageClass() {
        return this.getHomePage();
    }

    public RuntimeConfigurationType getConfigurationType() {
        if (SingularProperties.get().isFalse("singular.development")) {
            return RuntimeConfigurationType.DEPLOYMENT;
        }
        return RuntimeConfigurationType.DEVELOPMENT;
    }

    public ApplicationContext getApplicationContext() {
        return ApplicationContextProvider.get();
    }

    public TransparentWebMarkupContainer buildPageBody(String id, boolean withMenu, SingularAdminTemplate adminTemplate) {
        TransparentWebMarkupContainer pageBody = new TransparentWebMarkupContainer(id);
        if (!withMenu) {
            pageBody.add(new Behavior[]{WicketUtils.$b.classAppender((Serializable)((Object)"page-full-width"))});
        }
        pageBody.add(new Behavior[]{new SingularJSBehavior()});
        return pageBody;
    }

    public MarkupContainer buildPageFooter(String id) {
        return new Footer(id);
    }

    public MarkupContainer buildPageHeader(String id, boolean withMenu, SingularAdminTemplate adminTemplate) {
        return new Header(id, withMenu, adminTemplate.skinOptions);
    }
}

