/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.opensingular.flow.persistence.entity.ModuleEntity;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.opensingular.server.commons.config.IServerContext;
import org.opensingular.server.commons.spring.security.SingularUserDetails;

public class SingularSession
extends AuthenticatedWebSession {
    private ModuleEntity categoriaSelecionada;

    public SingularSession(Request request, Response response) {
        super(request);
    }

    public static SingularSession get() {
        return (SingularSession)Session.get();
    }

    protected boolean authenticate(String username, String password) {
        return true;
    }

    public Roles getRoles() {
        if (this.getUserDetails() != null) {
            return new Roles(this.getUserDetails().getPermissions().stream().map(sp -> sp.getSingularId()).collect(Collectors.toList()).toArray(new String[0]));
        }
        return new Roles();
    }

    public List<String> getRoleIds() {
        return this.getRoles().stream().collect(Collectors.toList());
    }

    public String getName() {
        if (this.getUserDetails() != null) {
            return this.getUserDetails().getDisplayName();
        }
        return "";
    }

    public String getUsername() {
        if (this.getUserDetails() != null) {
            return this.getUserDetails().getUsername();
        }
        return "";
    }

    public boolean isAuthtenticated() {
        return this.getUserDetails() != null;
    }

    public IServerContext getServerContext() {
        if (this.isAuthtenticated()) {
            return this.getUserDetails().getServerContext();
        }
        return null;
    }

    public <T extends SingularUserDetails> T getUserDetails() {
        return (T)((SingularUserDetails)ApplicationContextProvider.get().getBean(SingularUserDetails.class));
    }

    public ModuleEntity getCategoriaSelecionada() {
        return this.categoriaSelecionada;
    }

    public void setCategoriaSelecionada(ModuleEntity categoriaSelecionada) {
        this.categoriaSelecionada = categoriaSelecionada;
    }
}

