/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.builder;

import java.util.Arrays;
import java.util.Optional;
import org.opensingular.server.commons.wicket.builder.HTMLParameters;

public class MarkupCreator {
    public static String div(String wicketID) {
        return MarkupCreator.div(wicketID, null, new String[0]);
    }

    public static String p(String wicketID) {
        return MarkupCreator.p(wicketID, null, new String[0]);
    }

    public static String hr(String wicketID) {
        return MarkupCreator.hr(wicketID, null, new String[0]);
    }

    public static String span(String wicketID) {
        return MarkupCreator.span(wicketID, null, new String[0]);
    }

    public static String h5(String wicketID) {
        return MarkupCreator.h5(wicketID, null, new String[0]);
    }

    public static String h5(String wicketID, HTMLParameters parameters, String ... nesteds) {
        return MarkupCreator.newTag("h5", wicketID, parameters, nesteds);
    }

    public static String hr(String wicketID, HTMLParameters parameters, String ... nesteds) {
        return MarkupCreator.newTag("hr", wicketID, parameters, nesteds);
    }

    public static String button(String wicketID, HTMLParameters parameters, String ... nesteds) {
        return MarkupCreator.newTag("button", wicketID, parameters, nesteds);
    }

    public static String span(String wicketID, HTMLParameters parameters, String ... nesteds) {
        return MarkupCreator.newTag("span", wicketID, parameters, nesteds);
    }

    public static String div(String wicketID, HTMLParameters parameters, String ... nesteds) {
        return MarkupCreator.newTag("div", wicketID, parameters, nesteds);
    }

    public static String p(String wicketID, HTMLParameters parameters, String ... nesteds) {
        return MarkupCreator.newTag("p", wicketID, parameters, nesteds);
    }

    private static String newTag(String tag, String wicketID, HTMLParameters parameters, String ... nesteds) {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(tag).append(" wicket:id='").append(wicketID).append("' ");
        Optional.ofNullable(parameters).map(HTMLParameters::getParametersMap).ifPresent(p -> p.forEach((k, v) -> builder.append((String)k).append("='").append((String)v).append("' ")));
        builder.append('>');
        if (nesteds != null) {
            Arrays.stream(nesteds).forEach(builder::append);
        }
        builder.append("</").append(tag).append('>');
        return builder.toString();
    }
}

