/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.buttons;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.opensingular.lib.commons.lambda.IConsumer;
import org.opensingular.lib.commons.lambda.IFunction;
import org.opensingular.lib.commons.lambda.ISupplier;
import org.opensingular.lib.wicket.util.metronic.menu.DropdownMenu;
import org.opensingular.lib.wicket.util.util.WicketUtils;
import org.opensingular.server.commons.form.FormAction;
import org.opensingular.server.commons.service.dto.RequirementData;
import org.opensingular.server.commons.wicket.view.util.DispatcherPageUtil;

public class NewRequirementLink
extends Panel {
    private final String url;
    private final Map<String, String> params;
    private IModel<List<RequirementData>> requirements;
    private IModel<String> labelModel = new StringResourceModel("label.button.insert", (Component)this, null);

    public NewRequirementLink(String id, String url, Map<String, String> params, IModel<List<RequirementData>> requirements) {
        this(id, null, url, params, requirements);
    }

    public NewRequirementLink(String id, IModel<String> labelModel, String url, Map<String, String> params, IModel<List<RequirementData>> requirements) {
        super(id);
        this.url = url;
        this.params = params;
        this.labelModel = labelModel == null ? this.labelModel : labelModel;
        this.requirements = requirements;
        this.buildButtons();
    }

    protected void buildButtons() {
        this.addSingleButton((ISupplier<Boolean>)(ISupplier & Serializable)() -> Optional.ofNullable(this.requirements.getObject()).map(List::size).orElse(0) == 1);
        this.addDropdownButton((ISupplier<Boolean>)(ISupplier & Serializable)() -> Optional.ofNullable(this.requirements.getObject()).map(List::size).orElse(0) > 1);
    }

    protected void addSingleButton(ISupplier<Boolean> visibleSupplier) {
        Optional findFirst = ((List)this.requirements.getObject()).stream().findFirst();
        if (findFirst.isPresent()) {
            Link<String> newButton = this.buildLink("_botao", this.labelModel, (RequirementData)findFirst.get());
            newButton.add(new Behavior[]{WicketUtils.$b.visibleIf(visibleSupplier)});
            this.add(new Component[]{newButton});
        }
    }

    private Link<String> buildLink(String id, final IModel<String> labelModel, final RequirementData requirement) {
        Link botao = new Link(id){

            protected void onConfigure() {
                super.onConfigure();
                this.add(new Behavior[]{WicketUtils.$b.attr("href", (Serializable)((Object)NewRequirementLink.this.buildURL(requirement)))});
                this.add(new Behavior[]{WicketUtils.$b.attr("target", (Serializable)((Object)"_blank"))});
                this.setBody(labelModel);
            }

            public void onClick() {
            }
        };
        return botao;
    }

    protected void addDropdownButton(ISupplier<Boolean> visibleSupplier) {
        DropdownMenu dropdownMenu = new DropdownMenu("_novos");
        dropdownMenu.add(new Behavior[]{WicketUtils.$b.visibleIf(visibleSupplier)});
        dropdownMenu.add(new Behavior[]{WicketUtils.$b.onConfigure((IConsumer & Serializable)c -> {
            if (((Boolean)visibleSupplier.get()).booleanValue()) {
                for (RequirementData r : (List)this.requirements.getObject()) {
                    dropdownMenu.adicionarMenu((IFunction & Serializable)id -> this.buildLink((String)id, (IModel<String>)WicketUtils.$m.ofValue((Serializable)((Object)r.getLabel())), r));
                }
            }
        })});
        this.add(new Component[]{dropdownMenu});
    }

    protected String buildURL(RequirementData requirement) {
        String result = DispatcherPageUtil.baseURL(this.url).formAction(FormAction.FORM_FILL.getId()).requirementId(null).param("r", requirement.getId()).params(this.params).build();
        return result;
    }

    protected boolean getStatelessHint() {
        return true;
    }
}

