/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.error;

import com.google.common.base.Throwables;
import java.io.Serializable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.joda.time.DateTime;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.server.commons.exception.SingularServerIntegrationException;
import org.opensingular.server.commons.service.SendEmailToSupportService;
import org.opensingular.server.commons.wicket.view.template.ServerTemplate;
import org.springframework.transaction.UnexpectedRollbackException;
import org.wicketstuff.annotation.mount.MountPath;

@MountPath(value="public/error/500")
public class Page500
extends ServerTemplate
implements Loggable {
    private Exception exception;
    @Inject
    private SendEmailToSupportService singularSupportService;
    private final WebMarkupContainer detail = new WebMarkupContainer("detail");

    public Page500() {
        this.build();
    }

    public Page500(Exception exception) {
        this.exception = exception;
        this.build();
    }

    protected boolean isWithMenu() {
        return false;
    }

    protected void build() {
        String errorCode = Page500.errorCode();
        if (this.exception != null) {
            this.getLogger().error(errorCode, (Throwable)this.exception);
            this.sendExceptionEmail(errorCode, this.getStackTraceString(), this.getUrlException());
        }
        this.add(new Component[]{new Label("codigo-erro", (IModel)Model.of((Serializable)((Object)errorCode)))});
        this.pageHeader.setVisible(false);
        this.add(new Component[]{this.detail});
        this.detail.setVisible(false);
        this.detail.add(new Component[]{new WebMarkupContainer("message")});
        if (this.exception instanceof SingularServerIntegrationException) {
            this.detail.setVisible(true);
            this.detail.replace((Component)new Label("message", (IModel)Model.of((Serializable)((Object)this.exception.getMessage()))));
        }
    }

    private void sendExceptionEmail(String errorCode, String stackTrace, String urlException) {
        try {
            this.singularSupportService.sendEmailToSupport(errorCode, stackTrace, urlException);
        }
        catch (UnexpectedRollbackException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            this.getLogger().warn("A Rollback happened because of a exception while sending an e-mail to support {}", (Object)e.getMessage());
        }
    }

    private String getStackTraceString() {
        return Throwables.getStackTraceAsString((Throwable)this.exception);
    }

    private String getUrlException() {
        return ((HttpServletRequest)this.getRequest().getContainerRequest()).getRequestURL() + "?" + ((HttpServletRequest)this.getRequest().getContainerRequest()).getQueryString();
    }

    protected IModel<String> getContentTitle() {
        return Model.of((Serializable)((Object)""));
    }

    protected IModel<String> getContentSubtitle() {
        return Model.of((Serializable)((Object)""));
    }

    private static String errorCode() {
        DateTime now = DateTime.now();
        return String.format("SER-%04d-%02d%02d%02d-%02d%02d-%04d ", Page500.get(now.year()), Page500.get(now.monthOfYear()), Page500.get(now.dayOfMonth()), Page500.get(now.hourOfDay()), Page500.get(now.minuteOfHour()), Page500.get(now.secondOfMinute()), Page500.get(now.millisOfSecond()));
    }

    private static int get(DateTime.Property prop) {
        return prop.get();
    }
}

