/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.listener;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.wicket.core.request.handler.IPageClassRequestHandler;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.flow.RedirectToUrlException;
import org.apache.wicket.request.http.WebRequest;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.wicket.util.page.error.Error403Page;
import org.opensingular.server.commons.config.IServerContext;
import org.opensingular.server.commons.config.SingularServerConfiguration;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.spring.security.SecurityAuthPaths;
import org.opensingular.server.commons.spring.security.SecurityAuthPathsFactory;
import org.opensingular.server.commons.wicket.SingularServerApplication;
import org.opensingular.server.commons.wicket.SingularSession;
import org.opensingular.server.commons.wicket.error.Page410;
import org.opensingular.server.commons.wicket.error.Page500;
import org.opensingular.server.commons.wicket.listener.AjaxErrorRequestHandler;

public class SingularServerContextListener
extends AbstractRequestCycleListener
implements Loggable {
    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        Object userDetails;
        SingularServerConfiguration singularServerConfiguration = (SingularServerConfiguration)SingularServerApplication.get().getApplicationContext().getBean(SingularServerConfiguration.class);
        if (SingularSession.get().isAuthtenticated() && this.isPageRequest(handler) && !(userDetails = SingularSession.get().getUserDetails()).keepLoginThroughContexts()) {
            HttpServletRequest request = (HttpServletRequest)cycle.getRequest().getContainerRequest();
            IServerContext newContext = IServerContext.getContextFromRequest(request, singularServerConfiguration.getContexts());
            IServerContext currentContext = SingularSession.get().getServerContext();
            if (!currentContext.equals(newContext)) {
                this.resetLogin(cycle);
            }
        }
    }

    private void resetLogin(RequestCycle cycle) {
        SecurityAuthPathsFactory securityAuthPathsFactory = new SecurityAuthPathsFactory();
        SecurityAuthPaths securityAuthPaths = securityAuthPathsFactory.get();
        String redirectURL = securityAuthPaths.getLogoutPath(cycle);
        this.getLogger().info("Redirecting to {}", (Object)redirectURL);
        throw new RedirectToUrlException(redirectURL);
    }

    private void redirect403(RequestCycle cycle) {
        cycle.getOriginalResponse().reset();
        cycle.setResponsePage((IRequestablePage)new Error403Page());
    }

    public IRequestHandler onException(RequestCycle cycle, Exception ex) {
        SingularException singularException = this.getFirstSingularException(ex);
        if (singularException instanceof SingularServerException && ((WebRequest)RequestCycle.get().getRequest()).isAjax()) {
            return new AjaxErrorRequestHandler(singularException);
        }
        if (ex instanceof PageExpiredException) {
            return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)new Page410()));
        }
        return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)new Page500(ex)));
    }

    private SingularException getFirstSingularException(Exception ex) {
        for (Throwable t : ExceptionUtils.getThrowableList((Throwable)ex)) {
            if (!(t instanceof SingularException)) continue;
            return (SingularException)t;
        }
        return null;
    }

    private boolean isPageRequest(IRequestHandler handler) {
        return handler instanceof IPageClassRequestHandler;
    }
}

