/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.filter.CssAcceptingHeaderResponseFilter;
import org.apache.wicket.markup.head.filter.FilteringHeaderResponse;
import org.apache.wicket.markup.head.filter.JavaScriptAcceptingHeaderResponseFilter;
import org.apache.wicket.markup.html.IHeaderResponseDecorator;

public class SingularHeaderResponseDecorator
implements IHeaderResponseDecorator {
    public IHeaderResponse decorate(IHeaderResponse response) {
        return new SingularFilteringHeaderResponse(response);
    }

    private static class SingularFilteringHeaderResponse
    extends FilteringHeaderResponse {
        public SingularFilteringHeaderResponse(IHeaderResponse response) {
            super(response);
            this.setFilters(this.createFilters());
        }

        private Iterable<? extends FilteringHeaderResponse.IHeaderResponseFilter> createFilters() {
            ArrayList<FilteringHeaderResponse.IHeaderResponseFilter> filters = new ArrayList<FilteringHeaderResponse.IHeaderResponseFilter>(3);
            filters.add(this.createFooterFilter("javascript-container"));
            filters.add(this.createHeaderFilter("wicket-default-header-filter", filters));
            return filters;
        }

        protected FilteringHeaderResponse.IHeaderResponseFilter createFooterFilter(String footerBucketName) {
            return new JavaScriptAcceptingHeaderResponseFilter(footerBucketName);
        }

        protected FilteringHeaderResponse.IHeaderResponseFilter createHeaderEndFilter(String headerFilterName) {
            return new CssAcceptingHeaderResponseFilter(headerFilterName);
        }

        protected FilteringHeaderResponse.IHeaderResponseFilter createHeaderFilter(final String headerFilterName, final List<FilteringHeaderResponse.IHeaderResponseFilter> filters) {
            return new FilteringHeaderResponse.IHeaderResponseFilter(){

                public String getName() {
                    return headerFilterName;
                }

                public boolean accepts(HeaderItem item) {
                    boolean truth = true;
                    for (FilteringHeaderResponse.IHeaderResponseFilter filter : filters) {
                        if (this.equals(filter)) continue;
                        truth &= !filter.accepts(item);
                    }
                    return truth;
                }
            };
        }
    }
}

