/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.flow.RedirectToUrlException;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.opensingular.flow.core.STask;
import org.opensingular.flow.core.STransition;
import org.opensingular.flow.core.TaskInstance;
import org.opensingular.flow.core.TransitionAccess;
import org.opensingular.form.SIComposite;
import org.opensingular.form.SInstance;
import org.opensingular.form.SType;
import org.opensingular.form.document.RefType;
import org.opensingular.form.document.SDocument;
import org.opensingular.form.document.SDocumentConsumer;
import org.opensingular.form.persistence.FormKey;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.form.wicket.component.SingularButton;
import org.opensingular.form.wicket.component.SingularSaveButton;
import org.opensingular.form.wicket.component.SingularValidationButton;
import org.opensingular.form.wicket.enums.AnnotationMode;
import org.opensingular.form.wicket.enums.ViewMode;
import org.opensingular.form.wicket.panel.SingularFormPanel;
import org.opensingular.form.wicket.util.WicketFormProcessing;
import org.opensingular.internal.lib.support.spring.injection.SingularSpringInjector;
import org.opensingular.lib.commons.context.RefService;
import org.opensingular.lib.commons.lambda.IConsumer;
import org.opensingular.lib.commons.lambda.IFunction;
import org.opensingular.lib.commons.lambda.ISupplier;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.opensingular.lib.wicket.util.bootstrap.layout.BSContainer;
import org.opensingular.lib.wicket.util.bootstrap.layout.IBSComponentFactory;
import org.opensingular.lib.wicket.util.bootstrap.layout.TemplatePanel;
import org.opensingular.lib.wicket.util.modal.BSModalBorder;
import org.opensingular.lib.wicket.util.model.IReadOnlyModel;
import org.opensingular.lib.wicket.util.util.Shortcuts;
import org.opensingular.lib.wicket.util.util.WicketUtils;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.exception.SingularServerFormValidationError;
import org.opensingular.server.commons.flow.FlowResolver;
import org.opensingular.server.commons.metadata.SingularServerMetadata;
import org.opensingular.server.commons.persistence.entity.form.DraftEntity;
import org.opensingular.server.commons.persistence.entity.form.FormRequirementEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementDefinitionEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.requirement.SingularRequirement;
import org.opensingular.server.commons.service.FormRequirementService;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.service.RequirementSender;
import org.opensingular.server.commons.service.RequirementService;
import org.opensingular.server.commons.service.RequirementUtil;
import org.opensingular.server.commons.service.ServerSInstanceFlowAwareService;
import org.opensingular.server.commons.service.SingularRequirementService;
import org.opensingular.server.commons.service.dto.RequirementSenderFeedback;
import org.opensingular.server.commons.wicket.SingularSession;
import org.opensingular.server.commons.wicket.builder.HTMLParameters;
import org.opensingular.server.commons.wicket.builder.MarkupCreator;
import org.opensingular.server.commons.wicket.view.form.ExtensionButtonsPanel;
import org.opensingular.server.commons.wicket.view.form.FlowConfirmPanel;
import org.opensingular.server.commons.wicket.view.form.FormPageExecutionContext;
import org.opensingular.server.commons.wicket.view.form.STypeBasedFlowConfirmModal;
import org.opensingular.server.commons.wicket.view.form.ServerSendButton;
import org.opensingular.server.commons.wicket.view.form.SimpleMessageFlowConfirmModal;
import org.opensingular.server.commons.wicket.view.form.TransitionController;
import org.opensingular.server.commons.wicket.view.panel.FeedbackAposEnvioPanel;
import org.opensingular.server.commons.wicket.view.panel.NotificationPanel;
import org.opensingular.server.commons.wicket.view.template.ServerTemplate;
import org.opensingular.server.commons.wicket.view.util.ActionContext;
import org.opensingular.server.commons.wicket.view.util.ModuleButtonFactory;
import org.springframework.orm.hibernate4.HibernateOptimisticLockingFailureException;

public abstract class AbstractFormPage<RE extends RequirementEntity, RI extends RequirementInstance>
extends ServerTemplate
implements Loggable {
    protected final String typeName;
    protected final IModel<FormKey> formKeyModel;
    protected final FormPageExecutionContext config;
    protected final SingularFormPanel singularFormPanel;
    protected final IModel<Boolean> inheritParentFormData;
    protected final IModel<FormKey> parentRequirementFormKeyModel;
    protected final BSContainer<?> modalContainer = new BSContainer("modals");
    protected final BSModalBorder closeModal = this.construirCloseModal();
    private final Map<String, TransitionController<?>> transitionControllerMap = new HashMap();
    private Map<String, STypeBasedFlowConfirmModal<?, ?>> transitionConfirmModalMap = new HashMap();
    private BSModalBorder notificacoesModal;
    private FeedbackAposEnvioPanel feedbackAposEnvioPanel = null;
    private IModel<RI> currentModel;
    private transient Optional<TaskInstance> currentTaskInstance;
    @Inject
    private RequirementService<RE, RI> requirementService;
    @Inject
    private FormRequirementService<RE> formRequirementService;
    @Inject
    private SingularServerMetadata singularServerMetadata;

    public AbstractFormPage(@Nullable ActionContext context) {
        this(context, null);
    }

    public AbstractFormPage(@Nullable ActionContext context, @Nullable Class<? extends SType<?>> formType) {
        if (context == null) {
            String url = this.singularServerMetadata.getServerBaseUrl();
            this.getLogger().info(" Redirecting to {}", (Object)url);
            throw new RedirectToUrlException(url);
        }
        this.config = new FormPageExecutionContext(Objects.requireNonNull(context), this.getTypeName(formType), this.getFlowResolver(context), this.getRequirementSender(context));
        this.formKeyModel = WicketUtils.$m.ofValue();
        this.parentRequirementFormKeyModel = WicketUtils.$m.ofValue();
        this.inheritParentFormData = WicketUtils.$m.ofValue();
        this.typeName = this.config.getFormName();
        this.singularFormPanel = new SingularFormPanel("singular-panel");
        this.onBuildSingularFormPanel(this.singularFormPanel);
        context.getInheritParentFormData().ifPresent(arg_0 -> this.inheritParentFormData.setObject(arg_0));
        if (this.config.getFormName() == null) {
            throw new SingularServerException("Tipo do formul\u00e1rio da p\u00e1gina nao foi definido");
        }
    }

    private static IConsumer<SDocument> getDocumentExtraSetuper(IModel<? extends RequirementInstance> requirementModel) {
        return (IConsumer & Serializable)document -> document.bindLocalService("processService", ServerSInstanceFlowAwareService.class, RefService.of(() -> ((RequirementInstance)requirementModel.getObject()).getFlowInstance()));
    }

    protected void fillTransitionControllerMap(Map<String, TransitionController<?>> transitionControllerMap) {
    }

    protected Optional<TaskInstance> getCurrentTaskInstance() {
        if (this.currentTaskInstance == null) {
            this.currentTaskInstance = Optional.empty();
            this.config.getRequirementId().ifPresent(si -> {
                this.currentTaskInstance = this.requirementService.findCurrentTaskInstanceByRequirementId(this.config.getRequirementId().get());
            });
        }
        return this.currentTaskInstance;
    }

    private String getTypeName(@Nullable Class<? extends SType<?>> formType) {
        if (formType != null) {
            return RequirementUtil.getTypeName(formType);
        }
        return null;
    }

    private FlowResolver getFlowResolver(@Nullable ActionContext context) {
        return this.getSingularRequirement(context).map(SingularRequirement::getFlowResolver).orElse(null);
    }

    private Class<? extends RequirementSender> getRequirementSender(@Nullable ActionContext context) {
        return this.getSingularRequirement(context).map(SingularRequirement::getRequirementSenderBeanClass).orElse(null);
    }

    private Optional<SingularRequirement> getSingularRequirement(@Nullable ActionContext context) {
        SingularRequirementService requirementService = SingularRequirementService.get();
        return Optional.ofNullable(requirementService.getSingularRequirement(context));
    }

    @Nonnull
    protected final RequirementService<RE, RI> getRequirementService() {
        return Objects.requireNonNull(this.requirementService);
    }

    @Nonnull
    protected final FormRequirementService<RE> getFormRequirementService() {
        return Objects.requireNonNull(this.formRequirementService);
    }

    @Nonnull
    protected final IModel<RI> getRequirementModel() {
        if (this.currentModel == null) {
            throw new SingularServerException("A p\u00e1gina ainda n\u00e3o foi inicializada");
        }
        return this.currentModel;
    }

    @Nonnull
    protected final RI getRequirement() {
        if (this.currentModel != null && this.currentModel.getObject() != null) {
            return (RI)((RequirementInstance)this.currentModel.getObject());
        }
        throw new SingularServerException("O requerimento (" + RequirementInstance.class.getName() + ") ainda est\u00e1 null");
    }

    @Nonnull
    protected final Optional<RI> getRequirementOptional() {
        if (this.currentModel == null || this.currentModel.getObject() == null) {
            return Optional.empty();
        }
        return Optional.of(this.currentModel.getObject());
    }

    @Nonnull
    protected final SIComposite getInstance() {
        return (SIComposite)this.getSingularFormPanel().getInstance();
    }

    @Nonnull
    protected final FormPageExecutionContext getConfig() {
        return this.config;
    }

    protected boolean isWithMenu() {
        return false;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.configurarExibicaoNotificacoes();
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)new PackageResourceReference(AbstractFormPage.class, "CollapseFlowButtons.js")));
    }

    protected void onInitialize() {
        super.onInitialize();
        RI requirement = this.loadRequirement();
        this.currentModel = WicketUtils.$m.loadable((ISupplier & Serializable)() -> requirement != null && requirement.getCod() != null ? this.requirementService.getRequirement(requirement.getCod()) : requirement);
        this.currentModel.setObject(requirement);
        this.fillTransitionControllerMap(this.transitionControllerMap);
        SingularSpringInjector.get().injectAll(this.transitionControllerMap.values());
        SingularSpringInjector.get().injectAll(this.transitionConfirmModalMap.values());
        this.singularFormPanel.setViewMode(this.getViewMode(this.config));
        this.singularFormPanel.setAnnotationMode(this.getAnnotationMode(this.config));
        this.singularFormPanel.setInstanceCreator(() -> this.createInstance(this.formRequirementService.loadRefType(this.config.getFormName())));
        Form form = new Form("save-form");
        form.setMultiPart(true);
        form.add(new Component[]{this.singularFormPanel});
        form.add(new Component[]{this.modalContainer});
        BSModalBorder enviarModal = this.buildConfirmationModal(this.modalContainer, (IModel<? extends SInstance>)this.getInstanceModel());
        form.add(new Component[]{this.buildSendButton(enviarModal)});
        form.add(new Component[]{this.buildSaveButton()});
        form.add(new Component[]{this.buildFlowButtons()});
        form.add(new Component[]{this.buildValidateButton()});
        form.add(new Component[]{this.buildExtensionButtons()});
        form.add(new Component[]{this.buildCloseButton()});
        form.add(new Component[]{this.closeModal});
        form.add(new Component[]{this.buildExtraContent("extra-content")});
        this.add(new Component[]{form});
    }

    private Component buildExtensionButtons() {
        return new ExtensionButtonsPanel<RI>("extensions-buttons", this.currentModel, (IModel<? extends SInstance>)this.singularFormPanel.getInstanceModel()).setRenderBodyOnly(true);
    }

    private RI loadRequirement() {
        Object requirement;
        Optional<Long> requirementId = this.config.getRequirementId();
        if (requirementId.isPresent()) {
            requirement = this.requirementService.getRequirement(requirementId.get());
            FormEntity formEntityDraftOrRequirement = this.getDraftOrFormEntity(requirement);
            ((RequirementInstance)requirement).getMainForm();
            if (formEntityDraftOrRequirement != null) {
                this.formKeyModel.setObject((Object)this.formRequirementService.formKeyFromFormEntity(formEntityDraftOrRequirement));
            }
        } else {
            RequirementInstance parentRequirement = null;
            Optional<Long> parentRequirementId = this.config.getParentRequirementId();
            if (parentRequirementId.isPresent()) {
                parentRequirement = (RequirementInstance)this.requirementService.getRequirement(parentRequirementId.get());
                this.parentRequirementFormKeyModel.setObject((Object)this.formRequirementService.formKeyFromFormEntity(parentRequirement.getEntity().getMainForm()));
            }
            requirement = this.requirementService.createNewRequirementWithoutSave(null, parentRequirement, this::onNewRequirementCreation, this.getRequirementDefinitionEntity());
        }
        return requirement;
    }

    protected RequirementDefinitionEntity getRequirementDefinitionEntity() {
        return this.getConfig().getRequirementDefinitionId().map(this.requirementService::findRequirementDefinition).orElse(null);
    }

    private FormEntity getDraftOrFormEntity(RI requirement) {
        return ((RequirementInstance)requirement).getEntity().currentEntityDraftByType(this.getFormType()).map(DraftEntity::getForm).orElseGet(() -> this.getFormRequirementEntity(requirement).map(FormRequirementEntity::getForm).orElse(null));
    }

    private Optional<FormRequirementEntity> getFormRequirementEntity(RI requirement) {
        if (this.isMainForm()) {
            return this.formRequirementService.findFormRequirementEntityByType((RequirementInstance)requirement, this.getFormType());
        }
        return this.formRequirementService.findFormRequirementEntityByTypeAndTask((RequirementInstance)requirement, this.getFormType(), ((RequirementInstance)requirement).getCurrentTaskOrException());
    }

    protected ServerSendButton makeServerSendButton(String id, IModel<? extends SInstance> formInstance, BSModalBorder enviarModal) {
        return new ServerSendButton(id, formInstance, enviarModal);
    }

    private Component buildExtraContent(String id) {
        TemplatePanel extraPanel = new TemplatePanel(id, MarkupCreator.div("extraContainer"));
        BSContainer extraContainer = new BSContainer("extraContainer");
        extraPanel.add(new Component[]{extraContainer});
        this.appendExtraContent(extraContainer);
        extraPanel.add(new Behavior[]{WicketUtils.$b.visibleIf((ISupplier & Serializable)() -> extraContainer.visitChildren((object, visit) -> visit.stop((Object)"found!")) != null)});
        return extraPanel;
    }

    private Component buildPreFormPanelContent(String id) {
        TemplatePanel extraPanel = new TemplatePanel(id, MarkupCreator.div("extraContainer"));
        BSContainer extraContainer = new BSContainer("extraContainer");
        extraPanel.add(new Component[]{extraContainer});
        this.appendBeforeFormContent(extraContainer);
        extraPanel.add(new Behavior[]{WicketUtils.$b.visibleIf((ISupplier & Serializable)() -> extraContainer.visitChildren((object, visit) -> visit.stop((Object)"found!")) != null)});
        return extraPanel;
    }

    protected void appendExtraContent(BSContainer extraContainer) {
        extraContainer.newComponent(this::buildNotificacoesModal);
        extraContainer.newComponent(this::createFeedbackAposEnvioPanel);
        this.getTransitionControllerMap().forEach((k, v) -> v.appendExtraContent(extraContainer));
    }

    private Component createFeedbackAposEnvioPanel(String id) {
        this.feedbackAposEnvioPanel = this.buildFeedbackAposEnvioPanel(id);
        if (this.feedbackAposEnvioPanel == null) {
            return new WebMarkupContainer(id);
        }
        return this.feedbackAposEnvioPanel;
    }

    protected FeedbackAposEnvioPanel buildFeedbackAposEnvioPanel(String id) {
        return null;
    }

    private void onBuildSingularFormPanel(SingularFormPanel singularFormPanel) {
        singularFormPanel.setPreFormPanelFactory(this::buildPreFormPanelContent);
    }

    protected void appendBeforeFormContent(BSContainer container) {
    }

    @Nonnull
    protected abstract Optional<String> getIdentifier();

    @Deprecated
    protected void onNewRequirementCreation(RI requirement) {
    }

    protected void configureCustomButtons(BSContainer<?> buttonContainer, BSContainer<?> modalContainer, boolean transitionButtonsVisible, IModel<? extends SInstance> currentInstance) {
        Optional<TaskInstance> currentTaskInstanceOpt;
        Optional<Long> requirementId = this.config.getRequirementId();
        if (requirementId.isPresent()) {
            this.configureDiffButton(requirementId.get(), buttonContainer, currentInstance);
        }
        if (!(currentTaskInstanceOpt = this.getCurrentTaskInstance()).isPresent()) {
            buttonContainer.setVisible(false).setEnabled(false);
        } else {
            this.configureTransitionButtons(buttonContainer, modalContainer, transitionButtonsVisible, currentInstance, currentTaskInstanceOpt.get());
        }
        this.appendViewNotificationsButton(buttonContainer);
    }

    private void configureDiffButton(Long requirementId, BSContainer<?> buttonContainer, IModel<? extends SInstance> currentInstance) {
        if (this.hasMultipleVersionsAndIsMainForm(requirementId)) {
            this.appendButtonViewDiff(buttonContainer, requirementId, currentInstance);
        }
    }

    private void configureTransitionButtons(BSContainer<?> buttonContainer, BSContainer<?> modalContainer, boolean transitionButtonsVisibility, IModel<? extends SInstance> currentInstance, TaskInstance taskInstance) {
        int buttonsCount = 0;
        List transitions = this.getCurrentTaskInstance().flatMap(TaskInstance::getFlowTask).map(STask::getTransitions).orElse(Collections.emptyList());
        if (transitionButtonsVisibility && CollectionUtils.isNotEmpty(transitions)) {
            int index = 0;
            for (STransition t : transitions) {
                TransitionAccess transitionAccess = this.getButtonAccess(t, taskInstance);
                if (!transitionAccess.isVisible()) continue;
                String btnId = "flow-btn" + index;
                ++buttonsCount;
                this.buildFlowTransitionButton(btnId, buttonContainer, modalContainer, t.getName(), currentInstance, transitionAccess);
            }
        }
        if (buttonsCount > 2) {
            this.add(new Behavior[]{WicketUtils.$b.onReadyScript((IFunction & Serializable)s -> "$(window).resize(function(){FlowButtonsConfigurer.configure()});FlowButtonsConfigurer.configure();")});
        }
    }

    protected boolean hasMultipleVersionsAndIsMainForm(Long requirementId) {
        if (requirementId != null) {
            int totalVersoes = 0;
            RI requirement = this.requirementService.getRequirement(requirementId);
            String typeName = RequirementUtil.getTypeName(requirement);
            if (((RequirementInstance)requirement).getEntity().currentEntityDraftByType(typeName).isPresent()) {
                ++totalVersoes;
            }
            Long versoesConsolidadas = this.formRequirementService.countVersions(((RequirementInstance)requirement).getEntity().getMainForm().getCod());
            totalVersoes = (int)((long)totalVersoes + versoesConsolidadas);
            String formType = this.getFormType();
            return totalVersoes > 1 && formType.equalsIgnoreCase(typeName);
        }
        return false;
    }

    protected void appendButtonViewDiff(BSContainer<?> buttonContainer, Long requirementId, IModel<? extends SInstance> currentInstance) {
        buttonContainer.appendComponent((IBSComponentFactory & Serializable)id -> new ModuleButtonFactory(ActionContext.fromFormConfig(this.config), this.getAdditionalParams()).getDiffButton(id));
    }

    protected Map<String, String> getAdditionalParams() {
        return Collections.emptyMap();
    }

    protected final TransitionAccess getButtonAccess(STransition transition, TaskInstance t) {
        return transition.getAccessFor(t);
    }

    protected final RI getUpdatedRequirementFromInstance(IModel<? extends SInstance> currentInstance, boolean mainForm) {
        RI requirement = this.getRequirement();
        if (currentInstance.getObject() instanceof SIComposite && mainForm) {
            this.requirementService.updateRequirementDescription((SInstance)currentInstance.getObject(), requirement);
        }
        return requirement;
    }

    @Nonnull
    protected SInstance createInstance(@Nonnull RefType refType) {
        SDocumentConsumer extraSetup = SDocumentConsumer.of(AbstractFormPage.getDocumentExtraSetuper(this.getRequirementModel()));
        if (this.formKeyModel.getObject() == null) {
            if (this.parentRequirementFormKeyModel.getObject() != null && this.inheritParentFormData.getObject() != null && ((Boolean)this.inheritParentFormData.getObject()).booleanValue()) {
                return this.formRequirementService.newTransientSInstance((FormKey)this.parentRequirementFormKeyModel.getObject(), refType, false, extraSetup);
            }
            return this.formRequirementService.createInstance(refType, extraSetup);
        }
        return this.formRequirementService.getSInstance((FormKey)this.formKeyModel.getObject(), refType, extraSetup);
    }

    protected void buildFlowTransitionButton(String buttonId, BSContainer<?> buttonContainer, BSContainer<?> modalContainer, String transitionName, IModel<? extends SInstance> instanceModel, TransitionAccess transitionButtonEnabled) {
        BSModalBorder modal = this.buildFlowConfirmationModal(buttonId, modalContainer, transitionName, instanceModel);
        this.buildFlowButton(buttonId, buttonContainer, transitionName, modal, transitionButtonEnabled);
    }

    public void atualizarContentWorklist(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)"Singular.atualizarContentWorklist();");
    }

    protected BSModalBorder buildConfirmationModal(BSContainer<?> modalContainer, IModel<? extends SInstance> instanceModel) {
        TemplatePanel tpModal = modalContainer.newTemplateTag((IFunction & Serializable)tt -> "<div wicket:id='send-modal' class='portlet-body form'>\n<wicket:message key=\"label.confirm.message\"/>\n</div>\n");
        final BSModalBorder enviarModal = new BSModalBorder("send-modal", (IModel)this.getMessage("label.title.send"));
        enviarModal.addButton(BSModalBorder.ButtonStyle.CANCEL, "label.button.close", new AjaxButton("cancel-btn"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                enviarModal.hide(target);
            }
        }).addButton(BSModalBorder.ButtonStyle.CONFIRM, "label.button.confirm", (AjaxButton)new SingularSaveButton("confirm-btn", instanceModel){

            protected void onValidationSuccess(AjaxRequestTarget target, Form<?> form, IModel<? extends SInstance> instanceModel) {
                AbstractFormPage.this.send(instanceModel, target, enviarModal);
            }

            protected void onValidationError(AjaxRequestTarget target, Form<?> form, IModel<? extends SInstance> instanceModel) {
                enviarModal.hide(target);
                target.add(new Component[]{form});
                AbstractFormPage.this.addToastrErrorMessage("message.send.error", new String[0]);
            }
        });
        tpModal.add(new Component[]{enviarModal});
        return enviarModal;
    }

    protected void saveForm(IModel<? extends SInstance> currentInstance) {
        this.saveForm(currentInstance, null);
    }

    protected void saveForm(IModel<? extends SInstance> currentInstance, String transitionName) {
        this.onBeforeSave(currentInstance);
        SInstance instance = (SInstance)currentInstance.getObject();
        if (instance != null) {
            RI requirement = this.getUpdatedRequirementFromInstance(currentInstance, this.isMainForm());
            this.formKeyModel.setObject((Object)this.requirementService.saveOrUpdate(requirement, instance, this.isMainForm()));
            this.onSave(requirement, transitionName);
        }
    }

    protected void onSave(RI requirement, String transitionName) {
        this.transitionConfirmModalMap.forEach((k, v) -> {
            if (v.isDirty()) {
                this.getRequirementService().saveOrUpdate((RequirementInstance)requirement, (SInstance)v.getInstanceModel().getObject(), false);
                v.setDirty(false);
            }
        });
    }

    protected boolean onBeforeSend(IModel<? extends SInstance> currentInstance) {
        return true;
    }

    protected void onBeforeSave(IModel<? extends SInstance> currentInstance) {
    }

    protected void send(IModel<? extends SInstance> mi, AjaxRequestTarget ajxrt, BSModalBorder sm) {
        this.resolveFlow(mi);
        this.saveForm(mi);
        if (this.onBeforeSend(mi)) {
            RI requirement = this.getRequirement();
            SInstance instance = (SInstance)mi.getObject();
            String username = SingularSession.get().getUsername();
            try {
                Class<? extends RequirementSender> senderClass = this.config.getRequirementSender();
                RequirementSender sender = (RequirementSender)ApplicationContextProvider.get().getBean(senderClass);
                if (sender == null) {
                    throw new SingularServerException("O RequirementSender n\u00e3o foi configurado corretamente");
                }
                RequirementSenderFeedback sendedFeedback = sender.send((RequirementInstance)requirement, instance, username);
                this.onAfterSend(ajxrt, sm, sendedFeedback);
            }
            catch (Exception ex) {
                this.getRequirementModel().setObject(this.requirementService.getRequirement(((RequirementInstance)requirement).getCod()));
                throw SingularServerException.rethrow(ex.getMessage(), ex);
            }
        }
    }

    protected void resolveFlow(IModel<? extends SInstance> mi) {
        ((RequirementInstance)this.getRequirement()).setFlowDefinition(this.config.getFlowResolver().resolve(this.config, (SIComposite)mi.getObject()).orElseThrow(() -> new SingularServerException("N\u00e3o foi poss\u00edvel determinar o fluxo a ser inicicado.")));
    }

    protected void onAfterSend(AjaxRequestTarget target, BSModalBorder enviarModal, RequirementSenderFeedback sendedFeedback) {
        if (this.feedbackAposEnvioPanel != null) {
            enviarModal.hide(target);
            this.atualizarContentWorklist(target);
            this.feedbackAposEnvioPanel.show(target, sendedFeedback);
        } else {
            this.atualizarContentWorklist(target);
            this.addAfterSendSuccessMessage();
            target.appendJavaScript((CharSequence)"; window.close();");
        }
    }

    protected void addAfterSendSuccessMessage() {
        Optional<String> identifier = this.getIdentifier();
        if (identifier.isPresent()) {
            this.addToastrSuccessMessageWorklist("message.send.success.identifier", identifier.get());
        } else {
            this.addToastrSuccessMessageWorklist("message.send.success", new String[0]);
        }
    }

    protected void onBeforeExecuteTransition(AjaxRequestTarget ajaxRequestTarget, Form<?> form, String transitionName, IModel<? extends SInstance> currentInstance) throws SingularServerFormValidationError {
        STypeBasedFlowConfirmModal<?, ?> flowConfirmModal = this.transitionConfirmModalMap.get(transitionName);
        if (flowConfirmModal == null) {
            this.saveForm(currentInstance, transitionName);
        } else {
            boolean isFormOnModalValid = WicketFormProcessing.onFormSubmit(form, (AjaxRequestTarget)ajaxRequestTarget, flowConfirmModal.getInstanceModel(), (boolean)true, (boolean)true);
            if (isFormOnModalValid) {
                this.saveForm(currentInstance, transitionName);
            } else {
                throw new SingularServerFormValidationError();
            }
        }
    }

    protected void executeTransition(AjaxRequestTarget ajxrt, Form<?> form, String tn, IModel<? extends SInstance> mi) throws SingularServerFormValidationError {
        this.onBeforeExecuteTransition(ajxrt, form, tn, mi);
        RI requirement = this.getRequirement();
        Map<String, String> flowParameters = this.getFlowParameters(tn);
        Map<String, String> currentTransitionParameters = this.getCurrentTransitionParameters(tn);
        try {
            this.requirementService.executeTransition(tn, (RequirementInstance)requirement, this::onTransition, flowParameters, currentTransitionParameters);
            this.onTransitionExecuted(ajxrt, tn);
        }
        catch (Exception ex) {
            this.getRequirementModel().setObject(this.requirementService.getRequirement(((RequirementInstance)requirement).getCod()));
            throw SingularServerException.rethrow(ex.getMessage(), ex);
        }
    }

    protected Map<String, String> getCurrentTransitionParameters(String currentTransition) {
        return new HashMap<String, String>();
    }

    protected Map<String, String> getFlowParameters(String transition) {
        Map<String, String> moreParams;
        HashMap<String, String> params = new HashMap<String, String>();
        TransitionController<?> controller = this.getTransitionControllerMap().get(transition);
        STypeBasedFlowConfirmModal<?, ?> flowConfirmModal = this.transitionConfirmModalMap.get(transition);
        if (controller != null && flowConfirmModal != null && (moreParams = controller.getFlowParameters(this.getInstance(), (SInstance)flowConfirmModal.getInstanceModel().getObject())) != null) {
            params.putAll(moreParams);
        }
        return params;
    }

    protected void onTransition(RequirementInstance pe, String transitionName) {
        TransitionController<?> controller = this.getTransitionControllerMap().get(transitionName);
        if (controller != null) {
            STypeBasedFlowConfirmModal<?, ?> flowConfirmModal = this.transitionConfirmModalMap.get(transitionName);
            controller.onTransition(this.getInstance(), (SInstance)flowConfirmModal.getInstanceModel().getObject());
        }
    }

    protected void onTransitionExecuted(AjaxRequestTarget ajaxRequestTarget, String transitionName) {
        this.atualizarContentWorklist(ajaxRequestTarget);
        this.addToastrSuccessMessageWorklist("message.action.success", transitionName);
        this.closeBrowserWindow(ajaxRequestTarget);
    }

    protected void closeBrowserWindow(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavaScript((CharSequence)"window.close();");
    }

    protected final boolean isFlowInstanceCreated() {
        return ((RequirementInstance)this.getRequirement()).isFlowInstanceCreated();
    }

    private void buildFlowButton(String buttonId, BSContainer<?> buttonContainer, final String transitionName, final BSModalBorder confirmActionFlowModal, final TransitionAccess access) {
        TemplatePanel tp = buttonContainer.newTemplateTag((IFunction & Serializable)tt -> "<button  type='submit' class='btn flow-btn' wicket:id='" + buttonId + "'>\n <span wicket:id='flowButtonLabel' /> \n</button>\n");
        SingularButton singularButton = new SingularButton(buttonId, this.getFormInstance()){

            protected void onSubmit(AjaxRequestTarget ajaxRequestTarget, Form<?> form) {
                AbstractFormPage.this.showConfirmModal(transitionName, confirmActionFlowModal, ajaxRequestTarget);
            }

            protected void onInitialize() {
                super.onInitialize();
                this.setEnabled(access.isEnabled());
                Optional messageOpt = access.getMessage();
                if (messageOpt.isPresent()) {
                    this.add(new Behavior[]{WicketUtils.$b.attr("data-toggle", (Serializable)((Object)"tooltip"))});
                    this.add(new Behavior[]{WicketUtils.$b.attr("data-placement", (Serializable)((Object)"top"))});
                    this.add(new Behavior[]{WicketUtils.$b.attr("title", (Serializable)messageOpt.get())});
                }
            }
        };
        singularButton.add(new Component[]{new Label("flowButtonLabel", (Serializable)((Object)transitionName)).setRenderBodyOnly(true)});
        tp.add(new Component[]{singularButton});
    }

    protected void showConfirmModal(String transitionName, BSModalBorder modal, AjaxRequestTarget ajaxRequestTarget) {
        boolean show;
        TransitionController<?> controller = this.getTransitionControllerMap().get(transitionName);
        STypeBasedFlowConfirmModal<?, ?> flowConfirmModal = this.transitionConfirmModalMap.get(transitionName);
        boolean bl = show = controller == null || controller.onShow(this.getInstance(), (SInstance)flowConfirmModal.getInstanceModel().getObject(), modal, ajaxRequestTarget);
        if (show) {
            modal.show(ajaxRequestTarget);
        }
    }

    private BSModalBorder buildFlowConfirmationModal(String idSuffix, BSContainer<?> container, String tn, IModel<? extends SInstance> im) {
        FlowConfirmPanel flowConfirmPanel = this.resolveFlowConfirmModal("confirmPanel" + idSuffix, tn);
        container.appendTag("div", (Component)flowConfirmPanel);
        return flowConfirmPanel.getModalBorder();
    }

    protected FlowConfirmPanel resolveFlowConfirmModal(String id, String transitionName) {
        TransitionController<?> controller = this.getTransitionControllerMap().get(transitionName);
        if (controller == null || controller.getType() == null) {
            return new SimpleMessageFlowConfirmModal(id, transitionName, this);
        }
        RefType refType = this.getFormRequirementService().loadRefType(controller.getType());
        FormKey formKey = this.loadFormKeyFromTypeAndTask(controller.getType(), false).orElse(null);
        STypeBasedFlowConfirmModal modal = new STypeBasedFlowConfirmModal(id, transitionName, this, refType, formKey, controller);
        this.transitionConfirmModalMap.put(transitionName, modal);
        return modal;
    }

    private boolean isMainForm() {
        return this.config.isMainForm();
    }

    @Nonnull
    private String getFormType() {
        return this.config.getFormName();
    }

    protected ViewMode getViewMode(FormPageExecutionContext formPageConfig) {
        return formPageConfig.getViewMode();
    }

    protected AnnotationMode getAnnotationMode(FormPageExecutionContext formPageConfig) {
        return formPageConfig.getAnnotationMode();
    }

    @Nonnull
    protected final Optional<FormKey> loadFormKeyFromTypeAndTask(@Nonnull Class<? extends SType<?>> typeClass, boolean mainForm) {
        return this.formRequirementService.findFormRequirementEntity((RequirementInstance)this.getRequirement(), (Class<SType<?>>)typeClass, mainForm).map(x -> x.getCurrentDraftEntity() == null ? x.getForm() : x.getCurrentDraftEntity().getForm()).map(formEntity -> this.formRequirementService.formKeyFromFormEntity((FormEntity)formEntity));
    }

    private IReadOnlyModel<SInstance> getInstanceModel() {
        return () -> ((SingularFormPanel)this.singularFormPanel).getInstance();
    }

    private Component buildFlowButtons() {
        BSContainer buttonContainer = new BSContainer("custom-buttons");
        buttonContainer.setVisible(true);
        this.configureCustomButtons(buttonContainer, this.modalContainer, ViewMode.EDIT == this.getViewMode(this.config) || AnnotationMode.EDIT == this.getAnnotationMode(this.config), this.getFormInstance());
        return buttonContainer;
    }

    private Component buildSendButton(BSModalBorder enviarModal) {
        ServerSendButton button = this.makeServerSendButton("send-btn", this.getFormInstance(), enviarModal);
        return button.add(new Behavior[]{this.visibleOnlyIfDraftInEditionBehaviour()});
    }

    private Component buildSaveButton() {
        SingularButton button = new SingularButton("save-btn", this.getFormInstance()){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                super.onSubmit(target, form);
                try {
                    AbstractFormPage.this.saveForm(AbstractFormPage.this.getFormInstance());
                    AbstractFormPage.this.addToastrSuccessMessage("message.success", new String[0]);
                    AbstractFormPage.this.atualizarContentWorklist(target);
                }
                catch (HibernateOptimisticLockingFailureException e) {
                    AbstractFormPage.this.getLogger().debug(e.getMessage(), (Throwable)e);
                    AbstractFormPage.this.addToastrErrorMessage("message.save.concurrent_error", new String[0]);
                }
            }
        };
        return button.add(new Behavior[]{this.visibleOnlyInEditionBehaviour()});
    }

    protected AjaxLink<?> buildCloseButton() {
        return new AjaxLink("close-btn"){

            public void onClick(AjaxRequestTarget target) {
                if (AbstractFormPage.this.isReadOnly()) {
                    AbstractFormPage.this.atualizarContentWorklist(target);
                    target.appendJavaScript((CharSequence)"window.close()");
                } else {
                    AbstractFormPage.this.closeModal.show(target);
                }
            }
        };
    }

    private boolean isReadOnly() {
        return this.getViewMode(this.config) == ViewMode.READ_ONLY && this.getAnnotationMode(this.config) != AnnotationMode.EDIT;
    }

    protected BSModalBorder construirCloseModal() {
        final BSModalBorder closeModal = new BSModalBorder("close-modal", (IModel)this.getMessage("label.title.close.draft"));
        closeModal.addButton(BSModalBorder.ButtonStyle.CANCEL, "label.button.cancel", new AjaxButton("cancel-close-btn"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                closeModal.hide(target);
            }
        });
        closeModal.addButton(BSModalBorder.ButtonStyle.CONFIRM, "label.button.confirm", new AjaxButton("close-btn"){

            protected String getOnClickScript() {
                return " Singular.atualizarContentWorklist();window.close();";
            }
        });
        return closeModal;
    }

    protected Component buildValidateButton() {
        SingularValidationButton button = new SingularValidationButton("validate-btn", this.singularFormPanel.getInstanceModel()){

            protected void onValidationSuccess(AjaxRequestTarget target, Form<?> form, IModel<? extends SInstance> instanceModel) {
                AbstractFormPage.this.addToastrSuccessMessage("message.validation.success", new String[0]);
            }

            protected void onValidationError(AjaxRequestTarget target, Form<?> form, IModel<? extends SInstance> instanceModel) {
                super.onValidationError(target, form, instanceModel);
                AbstractFormPage.this.addToastrErrorMessage("message.validation.error", new String[0]);
            }
        };
        return button.add(new Behavior[]{this.visibleOnlyInEditionBehaviour()});
    }

    protected Behavior visibleOnlyInEditionBehaviour() {
        return WicketUtils.$b.visibleIf((ISupplier & Serializable)() -> this.getViewMode(this.config).isEdition() || this.getAnnotationMode(this.config).editable());
    }

    protected Behavior visibleOnlyIfDraftInEditionBehaviour() {
        return WicketUtils.$b.visibleIf((ISupplier & Serializable)() -> !this.isFlowInstanceCreated() && this.getViewMode(this.config).isEdition());
    }

    protected IModel<? extends SInstance> getFormInstance() {
        return this.singularFormPanel.getInstanceModel();
    }

    public final SingularFormPanel getSingularFormPanel() {
        return this.singularFormPanel;
    }

    protected IModel<String> getContentSubtitle() {
        return new Model();
    }

    protected Map<String, TransitionController<?>> getTransitionControllerMap() {
        return this.transitionControllerMap;
    }

    protected void configurarExibicaoNotificacoes() {
        this.notificacoesModal.setVisible(!((ArrayList)this.getNotificacoes().getObject()).isEmpty());
    }

    protected IModel<ArrayList<Pair<String, String>>> getNotificacoes() {
        return new Model(new ArrayList());
    }

    private Component buildNotificacoesModal(String id) {
        String modalPanelMarkup = MarkupCreator.div("modal-panel", null, MarkupCreator.div("list-view", null, MarkupCreator.div("notificacao")));
        TemplatePanel modalPanel = new TemplatePanel(id, modalPanelMarkup);
        ListView<Pair<String, String>> listView = new ListView<Pair<String, String>>("list-view", this.getNotificacoes()){

            protected void populateItem(ListItem<Pair<String, String>> item) {
                item.add(new Component[]{new NotificationPanel("notificacao", (IModel<Pair<String, String>>)item.getModel(), AbstractFormPage.this.getRequirementModel())});
            }
        };
        AjaxButton closeButton = new AjaxButton("close-button"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                super.onSubmit(target, form);
                AbstractFormPage.this.notificacoesModal.hide(target);
            }
        };
        this.notificacoesModal = new BSModalBorder("modal-panel");
        this.notificacoesModal.setTitleText((IModel)Model.of((Serializable)((Object)"Notifica\u00e7\u00f5es")));
        this.notificacoesModal.addButton(BSModalBorder.ButtonStyle.DEFAULT, (IModel)Shortcuts.$m.ofValue((Serializable)((Object)"Fechar")), (Button)closeButton);
        this.notificacoesModal.setSize(BSModalBorder.Size.NORMAL);
        return modalPanel.add(new Component[]{this.notificacoesModal.add(new Component[]{listView})});
    }

    private void appendViewNotificationsButton(BSContainer<?> container) {
        String markup = MarkupCreator.button("notificacoes", new HTMLParameters().add("type", "button").add("class", "btn"), MarkupCreator.span("notificacoesLabel"), MarkupCreator.span("notificacoesBadge", new HTMLParameters().add("class", "badge").add("style", "margin-left:5px;top:-2px;"), new String[0]));
        TemplatePanel buttonPanel = container.newTemplateTag((IFunction & Serializable)tt -> markup);
        AjaxButton viewButton = new AjaxButton("notificacoes"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                super.onSubmit(target, form);
                AbstractFormPage.this.notificacoesModal.show(target);
            }
        };
        viewButton.add(new Component[]{new Label("notificacoesLabel", (Serializable)((Object)"Visualizar Notifica\u00e7\u00f5es"))});
        viewButton.add(new Behavior[]{WicketUtils.$b.visibleIf((ISupplier & Serializable)() -> !((ArrayList)this.getNotificacoes().getObject()).isEmpty())});
        viewButton.add(new Component[]{new Label("notificacoesBadge", WicketUtils.$m.get((ISupplier & Serializable)() -> ((ArrayList)this.getNotificacoes().getObject()).size()))});
        buttonPanel.add(new Component[]{viewButton});
    }

    protected String getUserDisplayName() {
        Session session = Session.get();
        if (session instanceof SingularSession) {
            return SingularSession.get().getUserDetails().getDisplayName();
        }
        return "";
    }

    public Map<String, STypeBasedFlowConfirmModal<?, ?>> getTransitionConfirmModalMap() {
        return this.transitionConfirmModalMap;
    }

    public void onConfirmTransition(String transitionName, IModel<? extends SInstance> instanceModel) {
    }
}

