/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.form;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.opensingular.form.service.IFormService;
import org.opensingular.form.util.diff.DocumentDiff;
import org.opensingular.lib.wicket.util.bootstrap.layout.BSGrid;
import org.opensingular.lib.wicket.util.bootstrap.layout.BSLabel;
import org.opensingular.lib.wicket.util.bootstrap.layout.BSRow;
import org.opensingular.lib.wicket.util.bootstrap.layout.IBSComponentFactory;
import org.opensingular.lib.wicket.util.datatable.BSDataTable;
import org.opensingular.lib.wicket.util.output.BOutputPanel;
import org.opensingular.lib.wicket.util.util.Shortcuts;
import org.opensingular.server.commons.service.FormRequirementService;
import org.opensingular.server.commons.service.SingularDiffService;
import org.opensingular.server.commons.wicket.view.form.DiffVisualizer;
import org.opensingular.server.commons.wicket.view.template.ServerTemplate;
import org.opensingular.server.commons.wicket.view.util.ActionContext;
import org.opensingular.server.commons.wicket.view.util.ModuleButtonFactory;

public class DiffFormPage
extends ServerTemplate {
    @Inject
    protected FormRequirementService<?> formRequirementService;
    @Inject
    protected IFormService formService;
    @Inject
    protected SingularDiffService singularDiffService;
    private ActionContext config;
    protected BSDataTable<DocumentDiff, String> table;
    protected SingularDiffService.DiffSummary diffSummary;
    protected BSGrid contentGrid = new BSGrid("content");

    public DiffFormPage(ActionContext config) {
        this.config = config;
    }

    protected void onConfigure() {
        super.onConfigure();
        Optional<Long> requirementId = this.config.getRequirementId();
        if (requirementId.isPresent()) {
            this.diffSummary = this.singularDiffService.diffFromPrevious(requirementId.get());
            this.add(new Component[]{this.contentGrid});
            this.adicionarDatas(this.diffSummary.getPreviousFormVersionDate(), this.diffSummary.getCurrentFormVersionDate());
            this.add(new Component[]{new DiffVisualizer("diff", this.diffSummary.getDiff())});
        }
    }

    private void adicionarDatas(Date originalDate, Date newerDate) {
        BSRow container = this.contentGrid.newRow();
        this.appendDate(container, "Data da modifica\u00e7\u00e3o anterior:", originalDate);
        this.appendDate(container, "Data da modifica\u00e7\u00e3o atual:", newerDate);
        this.contentGrid.newRow().newCol(2).newFormGroup().appendLabel((Component)new BSLabel("label", (IModel)Shortcuts.$m.ofValue((Serializable)((Object)"")))).appendComponent((IBSComponentFactory & Serializable)id -> new ModuleButtonFactory(this.config).getViewVersionButton(id, this.diffSummary.getPreviousFormVersionId()));
    }

    private void appendDate(BSRow container, String fieldLabel, Date data) {
        container.newCol(2).newFormGroup().appendLabel((Component)new BSLabel("label", fieldLabel)).appendTag("div", (Component)new BOutputPanel("data", (IModel)Shortcuts.$m.ofValue((Serializable)((Object)new SimpleDateFormat("dd/MM/yyyy HH:mm").format(data)))));
    }

    protected IModel<String> getContentTitle() {
        return new Model();
    }

    protected IModel<String> getContentSubtitle() {
        return new Model();
    }

    protected boolean isWithMenu() {
        return false;
    }
}

