/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.form;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ISortableTreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.Node;
import org.apache.wicket.extensions.markup.html.repeater.util.SingleSortState;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.opensingular.form.util.diff.DiffInfo;
import org.opensingular.form.util.diff.DiffType;
import org.opensingular.form.util.diff.DocumentDiff;
import org.opensingular.lib.wicket.util.datatable.BSDataTableBuilder;
import org.opensingular.lib.wicket.util.datatable.BSTableTree;
import org.opensingular.lib.wicket.util.datatable.column.BSFolder;
import org.opensingular.lib.wicket.util.datatable.column.BSTreeColumn;
import org.opensingular.lib.wicket.util.util.WicketUtils;

public class DiffVisualizer
extends Panel {
    private DocumentDiff documentDiff;
    private BSTableTree<DiffInfo, Integer> tableTree;

    public DiffVisualizer(String id, DocumentDiff documentDiff) {
        super(id);
        this.documentDiff = documentDiff;
    }

    protected void onConfigure() {
        super.onConfigure();
        String id = "tree";
        Object result = this.documentDiff.getQtdChanges() > 0 ? this.createTreeTable(id) : new Label(id, (Serializable)((Object)"N\u00e3o h\u00e1 diferen\u00e7as"));
        this.queue(new Component[]{result});
    }

    private Component createTreeTable(String id) {
        DiffBSTreeColumn treeColumn = new DiffBSTreeColumn((IModel<String>)WicketUtils.$m.ofValue((Serializable)((Object)"Item")));
        treeColumn.setContentLabelFunction(DiffInfo::getLabel);
        this.tableTree = new BSDataTableBuilder(this.createProvider()).setBorderedTable(false).setStripedRows(false).appendColumn((IColumn)treeColumn).appendPropertyColumn((IModel)WicketUtils.$m.ofValue((Serializable)((Object)"Detalhe")), "detail").buildTree(id);
        this.tableTree.setModel((IModel)new DiffModel(this.documentDiff.getDiffRoot()));
        return this.tableTree;
    }

    private ISortableTreeProvider<DiffInfo, Integer> createProvider() {
        return new ISortableTreeProvider<DiffInfo, Integer>(){
            private final SingleSortState<Integer> state = new SingleSortState();

            public ISortState<Integer> getSortState() {
                return this.state;
            }

            public Iterator<? extends DiffInfo> getRoots() {
                return Collections.singletonList(DiffVisualizer.this.documentDiff.getDiffRoot()).iterator();
            }

            public boolean hasChildren(DiffInfo node) {
                return !node.getChildren().isEmpty();
            }

            public Iterator<? extends DiffInfo> getChildren(DiffInfo node) {
                return node.getChildren().iterator();
            }

            public IModel<DiffInfo> model(DiffInfo object) {
                return WicketUtils.$m.ofValue((Serializable)object);
            }

            public void detach() {
            }
        };
    }

    private static class DiffBSTreeColumn
    extends BSTreeColumn<DiffInfo, Integer> {
        public DiffBSTreeColumn(IModel<String> displayModel) {
            super(displayModel);
        }

        public DiffBSTreeColumn(IModel<String> displayModel, Integer sortProperty) {
            super(displayModel, (Object)sortProperty);
        }

        protected Component newNodeComponent(String componentId, IModel<DiffInfo> model) {
            return new Node<DiffInfo>(componentId, (AbstractTree)this.getTree(), model){

                protected Component createContent(String id, IModel<DiffInfo> model) {
                    return this.newContentComponent(id, model);
                }

                protected MarkupContainer createJunctionComponent(String id) {
                    MarkupContainer junction = super.createJunctionComponent(id);
                    junction.setVisible(((DiffInfo)this.getModelObject()).hasChildren());
                    return junction;
                }
            };
        }

        protected Component newContentComponent(String componentId, IModel<DiffInfo> model) {
            return new BSFolder<DiffInfo>(componentId, (AbstractTree)this.getTree(), model){

                protected IModel<?> newLabelModel(IModel<DiffInfo> model) {
                    return WicketUtils.$m.map(model, DiffInfo::getLabel);
                }

                protected String getIconStyleClass() {
                    DiffType type = ((DiffInfo)this.getModelObject()).getType();
                    if (DiffType.CHANGED_NEW == type) {
                        return "glyphicon glyphicon-plus diff-icon-new";
                    }
                    if (DiffType.CHANGED_CONTENT == type) {
                        return "glyphicon glyphicon-pencil diff-icon-changed";
                    }
                    if (DiffType.CHANGED_DELETED == type) {
                        return "glyphicon glyphicon-minus diff-icon-deleted";
                    }
                    return "";
                }
            };
        }
    }

    private static class DiffModel
    implements IModel<Set<DiffInfo>> {
        private Set<DiffInfo> diffs;

        public DiffModel(DiffInfo diffRoot) {
            this.diffs = this.collectAll(diffRoot);
        }

        private Set<DiffInfo> collectAll(DiffInfo diffRoot) {
            HashSet<DiffInfo> diffs = new HashSet<DiffInfo>();
            diffs.add(diffRoot);
            if (diffRoot.hasChildren()) {
                for (DiffInfo diffInfo : diffRoot.getChildren()) {
                    diffs.addAll(this.collectAll(diffInfo));
                }
            }
            return diffs;
        }

        public Set<DiffInfo> getObject() {
            return this.diffs;
        }

        public void setObject(Set<DiffInfo> diffs) {
            this.diffs = diffs;
        }

        public void detach() {
        }
    }
}

