/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.form;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.opensingular.form.SInstance;
import org.opensingular.form.wicket.component.SingularSaveButton;
import org.opensingular.lib.commons.extension.SingularExtensionUtil;
import org.opensingular.lib.wicket.util.util.WicketUtils;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.wicket.view.extension.RequirementButtonExtension;

public class ExtensionButtonsPanel<RI extends RequirementInstance>
extends Panel {
    private IModel<RI> petInstanceModel;
    private IModel<? extends SInstance> formModel;
    private List<RequirementButtonExtension> extensions;

    public ExtensionButtonsPanel(String id, IModel<RI> petInstanceModel, IModel<? extends SInstance> formModel) {
        super(id);
        this.petInstanceModel = petInstanceModel;
        this.formModel = formModel;
        this.extensions = this.lookupExtensions();
        this.addButtons();
    }

    private List<RequirementButtonExtension> lookupExtensions() {
        return SingularExtensionUtil.get().findExtensionsByClass(RequirementButtonExtension.class);
    }

    private void addButtons() {
        this.add(new Component[]{new ListView<RequirementButtonExtension>("buttons", this.extensions){

            protected void populateItem(ListItem<RequirementButtonExtension> item) {
                final RequirementButtonExtension itemModel = (RequirementButtonExtension)item.getModelObject();
                SingularSaveButton button = new SingularSaveButton("button", ExtensionButtonsPanel.this.formModel, itemModel.shouldValidateForm()){

                    protected void onValidationSuccess(AjaxRequestTarget target, Form<?> form, IModel<? extends SInstance> instanceModel) {
                        itemModel.onAction(new RequirementButtonExtension.ActionContext(target, form, (RequirementInstance)ExtensionButtonsPanel.this.petInstanceModel.getObject(), (SInstance)instanceModel.getObject()));
                    }
                };
                RequirementButtonExtension.ButtonView buttonView = itemModel.getButtonView();
                WebMarkupContainer icon = new WebMarkupContainer("icon");
                if (buttonView.getIcon() != null) {
                    icon.add(new Behavior[]{WicketUtils.$b.classAppender((Serializable)((Object)buttonView.getIcon().getCssClass()))});
                } else {
                    icon.setVisible(false);
                }
                button.add(new Component[]{icon});
                button.add(new Component[]{new Label("label", (Serializable)((Object)buttonView.getLabel())).setRenderBodyOnly(true)});
                item.add(new Component[]{button});
            }
        }.setRenderBodyOnly(true)});
    }
}

