/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.form;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.opensingular.form.SInstance;
import org.opensingular.form.wicket.component.SingularSaveButton;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.wicket.util.modal.BSModalBorder;
import org.opensingular.server.commons.exception.RequirementConcurrentModificationException;
import org.opensingular.server.commons.exception.SingularServerFormValidationError;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.wicket.view.form.AbstractFormPage;
import org.springframework.orm.hibernate4.HibernateOptimisticLockingFailureException;

public class FlowConfirmButton<RE extends RequirementEntity, RI extends RequirementInstance>
extends SingularSaveButton
implements Loggable {
    private final AbstractFormPage<RE, RI> formPage;
    private final String transitionName;
    private final BSModalBorder modal;

    public FlowConfirmButton(String transitionName, String id, IModel<? extends SInstance> model, boolean validate, AbstractFormPage<RE, RI> formPage, BSModalBorder modal) {
        super(id, model, validate);
        this.formPage = formPage;
        this.transitionName = transitionName;
        this.modal = modal;
    }

    protected void onValidationSuccess(AjaxRequestTarget ajaxRequestTarget, Form<?> form, IModel<? extends SInstance> model) {
        try {
            this.formPage.executeTransition(ajaxRequestTarget, form, this.transitionName, model);
        }
        catch (RequirementConcurrentModificationException | HibernateOptimisticLockingFailureException e) {
            this.getLogger().debug(((Throwable)e).getMessage(), (Throwable)e);
            this.configureBackDropAndShowError(ajaxRequestTarget, "message.save.concurrent_error");
        }
        catch (SingularServerFormValidationError ex) {
            this.getLogger().debug(ex.getMessage(), (Throwable)ex);
            this.configureBackDropAndShowError(ajaxRequestTarget, "message.send.error");
        }
    }

    private void configureBackDropAndShowError(AjaxRequestTarget ajaxRequestTarget, String messageKey) {
        this.modal.hide(ajaxRequestTarget);
        this.formPage.addToastrErrorMessage(messageKey, new String[0]);
        this.modal.show(ajaxRequestTarget);
    }

    protected void onValidationError(AjaxRequestTarget ajaxRequestTarget, Form<?> form, IModel<? extends SInstance> instanceModel) {
        this.modal.hide(ajaxRequestTarget);
        this.formPage.addToastrErrorMessage("N\u00e3o \u00e9 possivel " + this.transitionName.toLowerCase() + " enquanto houver corre\u00e7\u00f5es a serem feitas.", new String[0]);
        ajaxRequestTarget.add(new Component[]{form});
    }
}

