/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.form;

import java.io.Serializable;
import java.util.Optional;
import org.opensingular.form.wicket.enums.AnnotationMode;
import org.opensingular.form.wicket.enums.ViewMode;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.flow.FlowResolver;
import org.opensingular.server.commons.service.RequirementSender;
import org.opensingular.server.commons.wicket.view.util.ActionContext;

public class FormPageExecutionContext
implements Serializable {
    private ActionContext actionContext;
    private String formType;
    private FlowResolver resolver;
    private boolean mainForm = true;
    private Class<? extends RequirementSender> requirementSender;

    public FormPageExecutionContext(ActionContext context, String formName, FlowResolver resolver, Class<? extends RequirementSender> requirementSender) {
        this(context);
        this.resolver = resolver;
        if (formName != null) {
            this.mainForm = false;
            this.formType = formName;
        }
        this.requirementSender = requirementSender;
    }

    public FormPageExecutionContext(ActionContext context) {
        this.actionContext = context;
        this.actionContext.getFormName().ifPresent(f -> {
            this.formType = f;
        });
        this.mainForm = true;
    }

    public ViewMode getViewMode() {
        return this.actionContext.getFormAction().orElseThrow(() -> new SingularServerException("FormAction n\u00e3o encontrado !")).getViewMode();
    }

    public AnnotationMode getAnnotationMode() {
        return this.actionContext.getFormAction().orElseThrow(() -> new SingularServerException("FormAction n\u00e3o encontrado !")).getAnnotationMode();
    }

    public Optional<Long> getRequirementId() {
        return this.actionContext.getRequirementId();
    }

    public String getFormName() {
        return this.formType;
    }

    public Optional<Long> getParentRequirementId() {
        return this.actionContext.getParentRequirementId();
    }

    public boolean isMainForm() {
        return this.mainForm;
    }

    public FlowResolver getFlowResolver() {
        return this.resolver;
    }

    public ActionContext copyOfInnerActionContext() {
        return new ActionContext(this.actionContext);
    }

    public Class<? extends RequirementSender> getRequirementSender() {
        return this.requirementSender;
    }

    public Optional<Long> getRequirementDefinitionId() {
        return this.actionContext.getRequirementDefinitionId();
    }
}

