/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.form;

import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.form.wicket.enums.AnnotationMode;
import org.opensingular.form.wicket.enums.ViewMode;
import org.opensingular.form.wicket.panel.SingularFormPanel;
import org.opensingular.server.commons.service.FormRequirementService;
import org.opensingular.server.commons.wicket.view.template.ServerTemplate;

public class ReadOnlyFormPage
extends ServerTemplate {
    @Inject
    private FormRequirementService formRequirementService;
    protected final IModel<Long> formVersionEntityPK;
    protected final IModel<Boolean> showAnnotations;

    public ReadOnlyFormPage(IModel<Long> formVersionEntityPK, IModel<Boolean> showAnnotations) {
        this.formVersionEntityPK = formVersionEntityPK;
        this.showAnnotations = showAnnotations;
    }

    protected void onInitialize() {
        super.onInitialize();
        SingularFormPanel singularFormPanel = new SingularFormPanel("singularFormPanel");
        singularFormPanel.setInstanceCreator(() -> {
            FormVersionEntity formVersionEntity = this.formRequirementService.loadFormVersionEntity((Long)this.formVersionEntityPK.getObject());
            return this.formRequirementService.getSInstance(formVersionEntity);
        });
        singularFormPanel.setViewMode(ViewMode.READ_ONLY);
        singularFormPanel.setAnnotationMode((Boolean)this.showAnnotations.getObject() != false ? AnnotationMode.READ_ONLY : AnnotationMode.NONE);
        this.add(new Component[]{new Form("form").add(new Component[]{singularFormPanel})});
    }

    protected IModel<String> getContentTitle() {
        return new Model();
    }

    protected IModel<String> getContentSubtitle() {
        return new Model();
    }

    protected boolean isWithMenu() {
        return false;
    }
}

