/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.form;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.opensingular.form.SInstance;
import org.opensingular.form.document.RefType;
import org.opensingular.form.event.SInstanceEventType;
import org.opensingular.form.persistence.FormKey;
import org.opensingular.form.wicket.enums.ViewMode;
import org.opensingular.form.wicket.panel.SingularFormPanel;
import org.opensingular.lib.wicket.util.modal.BSModalBorder;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.wicket.view.form.AbstractFlowConfirmModal;
import org.opensingular.server.commons.wicket.view.form.AbstractFormPage;
import org.opensingular.server.commons.wicket.view.form.FlowConfirmButton;
import org.opensingular.server.commons.wicket.view.form.TransitionController;

public class STypeBasedFlowConfirmModal<RE extends RequirementEntity, RI extends RequirementInstance>
extends AbstractFlowConfirmModal<RE, RI> {
    private final RefType refType;
    private final FormKey formKey;
    private final TransitionController<?> transitionController;
    private boolean dirty;
    private SingularFormPanel singularFormPanel;

    public STypeBasedFlowConfirmModal(String id, String transitionName, AbstractFormPage<RE, RI> formPage, RefType refType, FormKey formKey, TransitionController<?> transitionController) {
        super(id, transitionName, formPage);
        this.refType = refType;
        this.formKey = formKey;
        this.transitionController = transitionController;
        this.dirty = false;
    }

    @Override
    protected void addDefaultConfirmButton(BSModalBorder modal) {
        modal.addButton(BSModalBorder.ButtonStyle.CONFIRM, "label.button.confirm", this.newFlowConfirmButton(this.getTransition(), this.getFormPage().getFormInstance(), this.getFormPage().getViewMode(this.getFormPage().getConfig()), modal));
    }

    @Override
    protected FlowConfirmButton<RE, RI> newFlowConfirmButton(String tn, IModel<? extends SInstance> im, ViewMode vm, BSModalBorder m) {
        return new FlowConfirmButton<RE, RI>(tn, "confirm-btn", im, this.transitionController.isValidatePageForm() && ViewMode.EDIT == vm, this.getFormPage(), m){

            @Override
            protected void onValidationSuccess(AjaxRequestTarget ajaxRequestTarget, Form<?> form, IModel<? extends SInstance> model) {
                STypeBasedFlowConfirmModal.this.setDirty(true);
                super.onValidationSuccess(ajaxRequestTarget, form, model);
            }
        };
    }

    private void addCloseButton(final BSModalBorder modal) {
        modal.addButton(BSModalBorder.ButtonStyle.CANCEL, (IModel)Model.of((Serializable)((Object)"Fechar")), new AjaxButton("cancel-btn"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                modal.hide(target);
            }
        }.setDefaultFormProcessing(false));
    }

    private SingularFormPanel buildSingularFormPanel() {
        this.singularFormPanel = new SingularFormPanel("singular-form-panel", true);
        this.singularFormPanel.setInstanceCreator(this::createInstance);
        this.singularFormPanel.setModalContainer(this.externalContainer);
        return this.singularFormPanel;
    }

    private SInstance createInstance() {
        SInstance instance = this.formKey != null ? this.getFormPage().getFormRequirementService().getSInstance(this.formKey, this.refType) : this.getFormPage().getFormRequirementService().createInstance(this.refType);
        if (this.transitionController != null) {
            this.transitionController.onCreateInstance(this.getFormPage().getInstance(), instance);
        }
        this.appendDirtyListener(instance);
        return instance;
    }

    private void appendDirtyListener(SInstance instance) {
        instance.getDocument().getInstanceListeners().add(SInstanceEventType.VALUE_CHANGED, evt -> this.setDirty(true));
    }

    public IModel<? extends SInstance> getInstanceModel() {
        return this.singularFormPanel.getInstanceModel();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public STypeBasedFlowConfirmModal setDirty(boolean dirty) {
        this.dirty = dirty;
        return this;
    }

    @Override
    protected void onConfirm(String tn, IModel<? extends SInstance> im) {
        super.onConfirm(tn, im);
        this.setDirty(true);
    }

    @Override
    void addComponentsToModalBorder(BSModalBorder modalBorder) {
        this.addCloseButton(modalBorder);
        this.addDefaultConfirmButton(modalBorder);
        modalBorder.add(new Component[]{this.buildSingularFormPanel()});
    }
}

