/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.panel;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.opensingular.lib.commons.lambda.IBiConsumer;
import org.opensingular.lib.wicket.util.modal.BSModalBorder;
import org.opensingular.lib.wicket.util.util.Shortcuts;
import org.opensingular.server.commons.service.dto.RequirementSenderFeedback;

public abstract class FeedbackAposEnvioPanel
extends Panel {
    protected BSModalBorder modal = new BSModalBorder("modal-panel");
    private IBiConsumer<AjaxRequestTarget, BSModalBorder> onClose;

    public FeedbackAposEnvioPanel(String id) {
        super(id);
        this.build();
    }

    private void build() {
        this.addTitle();
        this.addModalButtons();
        this.configureModalSize();
        this.add(new Component[]{this.modal});
    }

    protected void addModalButtons() {
        this.addCloseButton();
    }

    public void show(AjaxRequestTarget target, RequirementSenderFeedback sendedFeedback) {
        this.show(target, sendedFeedback, null);
    }

    public void show(AjaxRequestTarget target, RequirementSenderFeedback sendedFeedback, IBiConsumer<AjaxRequestTarget, BSModalBorder> onClose) {
        this.onClose = onClose;
        this.modal.show(target);
    }

    private void addCloseButton() {
        this.modal.addButton(BSModalBorder.ButtonStyle.CANCEL, (IModel)Shortcuts.$m.ofValue((Serializable)((Object)"Fechar")), (Button)new AjaxButton("close-button"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                super.onSubmit(target, form);
                FeedbackAposEnvioPanel.this.getOnClose().ifPresent(f -> f.accept((Object)target, (Object)FeedbackAposEnvioPanel.this.modal));
                target.appendJavaScript((CharSequence)"; window.close();");
            }
        });
    }

    private Optional<IBiConsumer<AjaxRequestTarget, BSModalBorder>> getOnClose() {
        return Optional.ofNullable(this.onClose);
    }

    private void addTitle() {
        this.modal.setTitleText((IModel)Model.of((Serializable)((Object)this.getTitle())));
    }

    @Nonnull
    public String getTitle() {
        return "Requerimento enviado com sucesso.";
    }

    private void configureModalSize() {
        this.modal.setSize(BSModalBorder.Size.NORMAL);
    }
}

