/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.panel;

import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.ContentDisposition;
import org.opensingular.form.wicket.link.FileDownloadLink;
import org.opensingular.lib.commons.dto.HtmlToPdfDTO;
import org.opensingular.lib.commons.pdf.HtmlToPdfConverter;
import org.opensingular.lib.wicket.util.model.IReadOnlyModel;
import org.opensingular.server.commons.service.RequirementInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationPanel<RI extends RequirementInstance>
extends Panel {
    @Inject
    private HtmlToPdfConverter htmlToPdfConverter;
    protected static final Logger LOGGER = LoggerFactory.getLogger(NotificationPanel.class);

    public NotificationPanel(String id, IModel<Pair<String, String>> model, IModel<RI> requirementModel) {
        super(id);
        this.add(new Component[]{new Label("title", (Serializable)((Pair)model.getObject()).getKey())});
        this.add(new Component[]{new FileDownloadLink("export-to-pdf", this.getPdfModel(model, requirementModel), ContentDisposition.INLINE, (String)((Pair)model.getObject()).getValue() + ".pdf")});
        this.add(new Component[]{new Label("content", (Serializable)((Pair)model.getObject()).getValue()).setEscapeModelStrings(false)});
    }

    protected IModel<File> getPdfModel(final IModel<Pair<String, String>> model, IModel<RI> requirementModel) {
        return new IReadOnlyModel<File>(){

            public File getObject() {
                HtmlToPdfDTO dto = new HtmlToPdfDTO();
                dto.setBody((String)((Pair)model.getObject()).getValue());
                return NotificationPanel.this.htmlToPdfConverter.convert(dto).orElse(null);
            }
        };
    }
}

