/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.template;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.TextRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.opensingular.flow.persistence.entity.ModuleEntity;
import org.opensingular.lib.commons.lambda.IConsumer;
import org.opensingular.lib.commons.lambda.ISupplier;
import org.opensingular.lib.commons.ui.Icon;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.wicket.util.menu.AbstractMenuItem;
import org.opensingular.lib.wicket.util.menu.MetronicMenu;
import org.opensingular.lib.wicket.util.menu.MetronicMenuGroup;
import org.opensingular.lib.wicket.util.resource.DefaultIcons;
import org.opensingular.lib.wicket.util.util.Shortcuts;
import org.opensingular.server.commons.connector.ModuleDriver;
import org.opensingular.server.commons.service.dto.BoxConfigurationData;
import org.opensingular.server.commons.service.dto.ItemBox;
import org.opensingular.server.commons.service.dto.RequirementDefinitionDTO;
import org.opensingular.server.commons.wicket.SingularSession;
import org.opensingular.server.commons.wicket.view.template.MenuService;
import org.opensingular.server.commons.wicket.view.template.SelecaoMenuItem;
import org.opensingular.server.commons.wicket.view.template.ServerMenuItem;
import org.springframework.security.core.userdetails.UserDetails;

public class Menu
extends Panel
implements Loggable {
    @Inject
    @SpringBean(required=false)
    private MenuService menuService;
    @Inject
    private ModuleDriver moduleDriver;
    private Class<? extends WebPage> boxPageClass;
    private MetronicMenu menu;

    public Menu(String id, Class<? extends WebPage> boxPageClass) {
        super(id);
        this.boxPageClass = boxPageClass;
        this.add(new Component[]{this.buildMenu()});
    }

    protected MetronicMenu buildMenu() {
        this.menu = new MetronicMenu("menu");
        this.buildMenuSelecao();
        this.getSelectedCategoryOrAll().forEach(module -> this.buildMenuGroup(this.menu, (ModuleEntity)module));
        return this.menu;
    }

    protected void buildMenuSelecao() {
        ArrayList<ModuleEntity> categories = new ArrayList<ModuleEntity>(0);
        if (this.menuService != null) {
            categories.addAll(this.menuService.getCategories());
        }
        SelecaoMenuItem selecaoMenuItem = new SelecaoMenuItem(categories);
        this.menu.addItem((AbstractMenuItem)selecaoMenuItem);
        if (categories.size() == 1) {
            selecaoMenuItem.add(new Behavior[]{Shortcuts.$b.onConfigure((IConsumer & Serializable)m -> m.setVisible(false))});
        }
    }

    protected List<ModuleEntity> getSelectedCategoryOrAll() {
        if (SingularSession.exists() && Session.get() instanceof SingularSession) {
            ModuleEntity categoriaSelecionada = SingularSession.get().getCategoriaSelecionada();
            if (categoriaSelecionada == null && this.menuService != null) {
                return this.menuService.getCategories();
            }
            return Collections.singletonList(categoriaSelecionada);
        }
        return Collections.emptyList();
    }

    protected void buildMenuGroup(MetronicMenu menu, ModuleEntity module) {
        Optional.ofNullable(this.menuService).map(menuService -> menuService.getMenusByCategory(module)).map(Collection::stream).orElse(Stream.empty()).forEach(boxConfigurationMetadata -> {
            List<MenuItemConfig> subMenus = boxConfigurationMetadata.getItemBoxes() == null ? this.buildDefaultSubMenus((BoxConfigurationData)boxConfigurationMetadata, module) : this.buildSubMenus((BoxConfigurationData)boxConfigurationMetadata, module);
            if (!subMenus.isEmpty()) {
                this.buildMenus(menu, (BoxConfigurationData)boxConfigurationMetadata, module, subMenus);
            }
        });
    }

    protected List<MenuItemConfig> buildDefaultSubMenus(BoxConfigurationData boxConfigurationMetadata, ModuleEntity module) {
        return Collections.emptyList();
    }

    private void buildMenus(MetronicMenu menu, BoxConfigurationData boxConfigurationMetadata, ModuleEntity module, List<MenuItemConfig> subMenus) {
        MetronicMenuGroup group = new MetronicMenuGroup((Icon)DefaultIcons.LAYERS, boxConfigurationMetadata.getLabel());
        menu.addItem((AbstractMenuItem)group);
        ArrayList<Pair<Component, ISupplier<String>>> itens = new ArrayList<Pair<Component, ISupplier<String>>>();
        for (MenuItemConfig t : subMenus) {
            PageParameters pageParameters = new PageParameters();
            pageParameters.add("mod", (Object)module.getCod());
            pageParameters.add("m", (Object)boxConfigurationMetadata.getLabel());
            pageParameters.add("t", (Object)t.name);
            ServerMenuItem i = new ServerMenuItem(t.icon, t.name, t.pageClass, t.page, pageParameters);
            group.addItem((AbstractMenuItem)i);
            itens.add((Pair<Component, ISupplier<String>>)Pair.of((Object)i.getHelper(), t.counterSupplier));
        }
        menu.add(new Behavior[]{new AddContadoresBehaviour(itens)});
        this.onBuildModuleGroup(group, menu);
    }

    protected void onBuildModuleGroup(MetronicMenuGroup group, MetronicMenu menu) {
    }

    private List<MenuItemConfig> buildSubMenus(BoxConfigurationData boxConfigurationMetadata, ModuleEntity module) {
        List<String> abbreviations = boxConfigurationMetadata.getProcesses().stream().map(RequirementDefinitionDTO::getAbbreviation).collect(Collectors.toList());
        ArrayList<MenuItemConfig> configs = new ArrayList<MenuItemConfig>();
        for (ItemBox itemBoxDTO : boxConfigurationMetadata.getItemBoxes()) {
            ISupplier<String> countSupplier = this.createCountSupplier(itemBoxDTO, abbreviations, module);
            configs.add(MenuItemConfig.of(this.getBoxPageClass(), itemBoxDTO.getName(), itemBoxDTO.getHelpText(), itemBoxDTO.getIcone(), countSupplier));
        }
        return configs;
    }

    protected ISupplier<String> createCountSupplier(ItemBox itemBoxDTO, List<String> abbreviations, ModuleEntity module) {
        return (ISupplier & Serializable)() -> this.moduleDriver.countAll(module, itemBoxDTO, abbreviations, this.getIdCurrentUser());
    }

    protected String getIdPessoa() {
        return this.getIdCurrentUser();
    }

    protected String getIdCurrentUser() {
        Object singularUserDetails = SingularSession.get().getUserDetails();
        return Optional.ofNullable(singularUserDetails).map(UserDetails::getUsername).orElse(null);
    }

    public Class<? extends Page> getBoxPageClass() {
        Class homePage = WebApplication.get().getHomePage();
        if (homePage != null) {
            return homePage;
        }
        return this.boxPageClass;
    }

    protected static class MenuItemConfig {
        public IRequestablePage page;
        public String name;
        public String helpText;
        public Class<? extends IRequestablePage> pageClass;
        public Icon icon;
        public ISupplier<String> counterSupplier;

        protected MenuItemConfig() {
        }

        public static MenuItemConfig of(Class<? extends IRequestablePage> pageClass, String name, String helpText, Icon icon, ISupplier<String> counterSupplier) {
            MenuItemConfig mic = new MenuItemConfig();
            mic.pageClass = pageClass;
            mic.name = name;
            mic.helpText = helpText;
            mic.icon = icon;
            mic.counterSupplier = counterSupplier;
            return mic;
        }

        static MenuItemConfig of(IRequestablePage page, String name, String helpText, Icon icon, ISupplier<String> counterSupplier) {
            MenuItemConfig mic = new MenuItemConfig();
            mic.page = page;
            mic.name = name;
            mic.helpText = helpText;
            mic.icon = icon;
            mic.counterSupplier = counterSupplier;
            return mic;
        }
    }

    protected static class AddContadoresBehaviour
    extends AbstractDefaultAjaxBehavior {
        private final List<Pair<Component, ISupplier<String>>> itens;

        public AddContadoresBehaviour(List<Pair<Component, ISupplier<String>>> itens) {
            this.itens = itens;
        }

        public void renderHead(Component component, IHeaderResponse response) {
            super.renderHead(component, response);
            StringBuilder js = new StringBuilder();
            js.append(" window.Singular = window.Singular || {};");
            js.append(" window.Singular.contadores =  window.Singular.contadores || []; ");
            js.append(" (function() {");
            js.append("     var novoContador = function(){ ");
            js.append("         $(document).ready(function(){ ");
            js.append("             $(document).ready(function(){");
            js.append("                 $.getJSON('").append(this.getCallbackUrl()).append("', function(json) { ");
            for (int i = 0; i < this.itens.size(); ++i) {
                String markupId = ((Component)this.itens.get(i).getLeft()).getMarkupId();
                String currentItem = "item" + i;
                js.append("var ").append(currentItem).append(" = ").append(" $('#").append(markupId).append("');");
                js.append(currentItem).append(".hide(); ");
                js.append(currentItem).append(".addClass('badge badge-danger'); ");
                js.append(currentItem).append(".html(json.").append(currentItem).append(");");
                js.append(currentItem).append(".fadeIn('slow'); ");
            }
            js.append("                 });");
            js.append("             });");
            js.append("         });");
            js.append("     };");
            js.append("     novoContador(); ");
            js.append("     window.Singular.contadores.push(novoContador); ");
            js.append(" }());");
            js.append(" window.Singular.atualizarContadores  = function(){$(window.Singular.contadores).each(function(){this();});}; ");
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)js));
        }

        protected void respond(AjaxRequestTarget target) {
            String type = "application/json";
            String encoding = StandardCharsets.UTF_8.name();
            StringBuilder json = new StringBuilder();
            json.append('{');
            for (int i = 0; i < this.itens.size(); ++i) {
                json.append("\"item").append(i).append('\"').append(':').append((String)((ISupplier)this.itens.get(i).getRight()).get());
                if (i + 1 == this.itens.size()) continue;
                json.append(',');
            }
            json.append('}');
            RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)new TextRequestHandler("application/json", encoding, json.toString()));
        }
    }
}

