/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.template;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.opensingular.flow.persistence.entity.ModuleEntity;
import org.opensingular.lib.commons.lambda.IBiConsumer;
import org.opensingular.lib.wicket.util.behavior.BSSelectInitBehaviour;
import org.opensingular.lib.wicket.util.behavior.FormComponentAjaxUpdateBehavior;
import org.opensingular.lib.wicket.util.menu.AbstractMenuItem;
import org.opensingular.server.commons.service.dto.BoxConfigurationData;
import org.opensingular.server.commons.wicket.SingularSession;
import org.opensingular.server.commons.wicket.view.template.MenuService;

public class SelecaoMenuItem
extends AbstractMenuItem {
    @Inject
    @SpringBean(required=false)
    private MenuService menuService;
    private List<ModuleEntity> categorias;

    public SelecaoMenuItem(List<ModuleEntity> categorias) {
        super("menu-item");
        this.categorias = categorias;
    }

    protected void onInitialize() {
        super.onInitialize();
        Form form = new Form("form");
        Model model = new Model((Serializable)SingularSession.get().getCategoriaSelecionada());
        DropDownChoice select = new DropDownChoice("select", (IModel)model, this.categorias, (IChoiceRenderer)new ChoiceRenderer("name", "cod"));
        form.add(new Component[]{select});
        select.add(new Behavior[]{new BSSelectInitBehaviour()});
        select.add(new Behavior[]{new FormComponentAjaxUpdateBehavior("change", (IBiConsumer & Serializable)(target, component) -> {
            ModuleEntity categoriaSelecionada = (ModuleEntity)component.getDefaultModelObject();
            SingularSession.get().setCategoriaSelecionada(categoriaSelecionada);
            this.getPage().getPageParameters().set("mod", (Object)categoriaSelecionada.getCod());
            BoxConfigurationData boxConfigurationMetadataDTO = this.getDefaultMenuSelection(categoriaSelecionada);
            if (boxConfigurationMetadataDTO != null) {
                this.getPage().getPageParameters().set("m", (Object)boxConfigurationMetadataDTO.getLabel());
            } else {
                this.getPage().getPageParameters().remove("m", new String[0]);
            }
            this.setResponsePage(this.getPage().getClass(), this.getPage().getPageParameters());
        })});
        this.add(new Component[]{form});
    }

    private BoxConfigurationData getDefaultMenuSelection(ModuleEntity categoriaSelecionada) {
        return this.menuService.getDefaultSelectedMenu(categoriaSelecionada);
    }

    protected boolean configureActiveItem() {
        return false;
    }
}

