/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.template;

import de.alpharogroup.wicket.js.addon.toastr.ToastrType;
import javax.annotation.Nonnull;
import org.apache.wicket.Component;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.wicket.util.template.admin.SingularAdminTemplate;
import org.opensingular.server.commons.wicket.view.SingularToastrHelper;
import org.opensingular.server.commons.wicket.view.template.Menu;

public abstract class ServerTemplate
extends SingularAdminTemplate {
    public ServerTemplate() {
    }

    public ServerTemplate(PageParameters parameters) {
        super(parameters);
    }

    @Nonnull
    protected WebMarkupContainer buildPageMenu(String id) {
        return new Menu(id, this.getPageClass());
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forUrl((String)"/singular-static/resources/singular/fonts/google/open-sans.css"));
        response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)new PackageResourceReference(ServerTemplate.class, "singular.js")));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new PackageResourceReference(ServerTemplate.class, "ServerTemplate.css")));
        if (SingularProperties.get().isTrue("singular.analytics.enabled")) {
            response.render((HeaderItem)JavaScriptHeaderItem.forUrl((String)this.skinnableResource("/layout4/scripts/analytics.js")));
        }
    }

    protected StringResourceModel getMessage(String prop) {
        return new StringResourceModel(prop.trim(), (Component)this, null);
    }

    public void addToastrSuccessMessage(String messageKey, String ... args) {
        new SingularToastrHelper((Component)this).addToastrMessage(ToastrType.SUCCESS, messageKey, args);
    }

    public void addToastrErrorMessage(String messageKey, String ... args) {
        new SingularToastrHelper((Component)this).addToastrMessage(ToastrType.ERROR, messageKey, args);
    }

    public void addToastrWarningMessage(String messageKey, String ... args) {
        new SingularToastrHelper((Component)this).addToastrMessage(ToastrType.WARNING, messageKey, args);
    }

    public void addToastrInfoMessage(String messageKey, String ... args) {
        new SingularToastrHelper((Component)this).addToastrMessage(ToastrType.INFO, messageKey, args);
    }

    public void addToastrSuccessMessageWorklist(String messageKey, String ... args) {
        new SingularToastrHelper((Component)this).addToastrMessageWorklist(ToastrType.SUCCESS, messageKey, args);
    }

    public void addToastrErrorMessageWorklist(String messageKey, String ... args) {
        new SingularToastrHelper((Component)this).addToastrMessageWorklist(ToastrType.ERROR, messageKey, args);
    }

    public void addToastrWarningMessageWorklist(String messageKey, String ... args) {
        new SingularToastrHelper((Component)this).addToastrMessageWorklist(ToastrType.WARNING, messageKey, args);
    }

    protected void addToastrInfoMessageWorklist(String messageKey, String ... args) {
        new SingularToastrHelper((Component)this).addToastrMessageWorklist(ToastrType.INFO, messageKey, args);
    }
}

