/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.template;

import java.io.Serializable;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.StatelessLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.flow.RedirectToUrlException;
import org.opensingular.lib.wicket.util.template.SkinOptions;
import org.opensingular.lib.wicket.util.util.WicketUtils;
import org.opensingular.server.commons.spring.security.SecurityAuthPaths;
import org.opensingular.server.commons.spring.security.SecurityAuthPathsFactory;
import org.opensingular.server.commons.wicket.SingularSession;

public class TopMenu
extends Panel {
    protected SkinOptions option;

    public TopMenu(String id, SkinOptions option) {
        super(id);
        this.option = option;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildContent();
    }

    protected void buildContent() {
        this.queue(new Component[]{new Label("nome", (IModel)WicketUtils.$m.ofValue((Serializable)((Object)SingularSession.get().getName())))});
        WebMarkupContainer avatar = new WebMarkupContainer("codrh");
        Optional<Object> avatarSrc = Optional.ofNullable(null);
        avatarSrc.ifPresent(src -> avatar.add(new Behavior[]{WicketUtils.$b.attr("src", (Serializable)((Object)src))}));
        this.queue(new Component[]{avatar});
        avatar.setVisible(avatarSrc.isPresent());
        SecurityAuthPathsFactory securityAuthPathsFactory = new SecurityAuthPathsFactory();
        final SecurityAuthPaths securityAuthPaths = securityAuthPathsFactory.get();
        Link logout = new Link("logout"){

            public void onClick() {
                throw new RedirectToUrlException(securityAuthPaths.getLogoutPath(RequestCycle.get()));
            }
        };
        this.queue(new Component[]{logout});
    }

    protected ListView buildSkinOptions() {
        return new ListView<SkinOptions.Skin>("skin_options", this.option.options()){

            protected void populateItem(ListItem item) {
                SkinOptions.Skin skin = (SkinOptions.Skin)item.getModel().getObject();
                item.add(new Component[]{TopMenu.this.buildSelectSkinLink(skin)});
                item.queue(new Component[]{new Label("label", (Serializable)((Object)skin.getName()))});
            }
        };
    }

    private StatelessLink buildSelectSkinLink(final SkinOptions.Skin skin) {
        return new StatelessLink("change_action"){

            public void onClick() {
                TopMenu.this.option.selectSkin(skin);
                TopMenu.this.refreshPage();
            }
        };
    }

    private void refreshPage() {
        this.setResponsePage((IRequestablePage)this.getPage());
    }
}

