/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.wicket.view.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.opensingular.server.commons.wicket.view.util.ActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherPageUtil {
    public static final String DISPATCHER_PAGE_PATH = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(DispatcherPageUtil.class);
    private static final String ENCODING = StandardCharsets.UTF_8.name();
    private String url;

    private DispatcherPageUtil(String url) {
        this.url = url;
    }

    public static DispatcherPageUtil baseURL(String baseURL) {
        return new DispatcherPageUtil(baseURL);
    }

    private static String encodeParameter(Object param) {
        try {
            return URLEncoder.encode(String.valueOf(param), ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String buildFullURL(ActionContext actionContext) {
        return DispatcherPageUtil.getBaseURL() + '?' + actionContext.toURL();
    }

    public static String getBaseURL() {
        RequestCycle requestCycle = RequestCycle.get();
        Request request = requestCycle.getRequest();
        String currentPath = request.getUrl().toString();
        String fullUrl = requestCycle.getUrlRenderer().renderFullUrl(request.getUrl());
        if (StringUtils.isNotBlank((CharSequence)currentPath)) {
            int beginPath = fullUrl.lastIndexOf(currentPath);
            fullUrl = fullUrl.substring(0, beginPath - 1);
        }
        Optional<String> contextPath = Optional.ofNullable(requestCycle.getRequest().getContextPath());
        Optional<String> filterPath = Optional.ofNullable(requestCycle.getRequest().getFilterPath());
        return fullUrl + contextPath.orElse("") + filterPath.orElse("");
    }

    public DispatcherPageUrlBuilder formAction(Object formAction) {
        return new DispatcherPageUrlBuilder(this.url + "?dispatch=true&" + "a" + "=" + DispatcherPageUtil.encodeParameter(formAction));
    }

    public static class DispatcherPageUrlAdditionalParamsBuilder {
        private String url;

        private DispatcherPageUrlAdditionalParamsBuilder(String url) {
            this.url = url;
        }

        public DispatcherPageUrlAdditionalParamsBuilder params(Map<String, String> params) {
            params.forEach(this::param);
            return this;
        }

        public DispatcherPageUrlAdditionalParamsBuilder param(String name, Object value) {
            if (name != null && value != null) {
                this.url = this.url + "&" + name + "=" + DispatcherPageUtil.encodeParameter(value);
            }
            return this;
        }

        public String build() {
            return this.url;
        }
    }

    public static class DispatcherPageUrlBuilder {
        private String url;

        private DispatcherPageUrlBuilder(String url) {
            this.url = url;
        }

        public DispatcherPageUrlAdditionalParamsBuilder requirementId(Object formId) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)formId)) {
                return new DispatcherPageUrlAdditionalParamsBuilder(this.url + "&" + "k" + "=" + DispatcherPageUtil.encodeParameter(formId));
            }
            return new DispatcherPageUrlAdditionalParamsBuilder(this.url);
        }
    }
}

