/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.support.spring.injection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ResolvableType;

class FieldBeansCollector {
    private final FieldType fieldType;
    private final Map<Object, Object> beansToInjectMap;
    private final Collection<Object> beansToInjectColl;

    public FieldBeansCollector(ResolvableType fieldResolvableType) {
        Class clazz = fieldResolvableType.resolve();
        if (clazz == Map.class) {
            this.fieldType = FieldType.MAP;
            this.beansToInjectColl = null;
            this.beansToInjectMap = new HashMap<Object, Object>();
        } else if (clazz == Set.class) {
            this.fieldType = FieldType.SET;
            this.beansToInjectColl = new HashSet<Object>();
            this.beansToInjectMap = null;
        } else if (clazz == List.class) {
            this.fieldType = FieldType.LIST;
            this.beansToInjectColl = new ArrayList<Object>();
            this.beansToInjectMap = null;
        } else {
            this.fieldType = FieldType.NONE;
            this.beansToInjectColl = null;
            this.beansToInjectMap = null;
        }
    }

    public Object getBeansToInject() {
        if (this.beansToInjectMap != null && !this.beansToInjectMap.isEmpty()) {
            return this.beansToInjectMap;
        }
        if (this.beansToInjectColl != null && !this.beansToInjectColl.isEmpty()) {
            return this.beansToInjectColl;
        }
        return null;
    }

    public void addBean(String beanName, Object bean) {
        switch (this.fieldType) {
            case LIST: 
            case SET: {
                this.beansToInjectColl.add(bean);
                break;
            }
            case MAP: {
                this.beansToInjectMap.put(beanName, bean);
                break;
            }
        }
    }

    public static enum FieldType {
        LIST,
        SET,
        MAP,
        NONE;

    }
}

