/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.support.spring.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.internal.lib.commons.injection.FieldInjectionInfo;
import org.opensingular.internal.lib.commons.injection.SingularFieldValueFactory;
import org.opensingular.internal.lib.commons.injection.SingularInjectionException;
import org.opensingular.internal.lib.support.spring.injection.LazyInitProxyFactory;
import org.opensingular.internal.lib.support.spring.injection.SpringBeanLocator;
import org.opensingular.lib.commons.lambda.ISupplier;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.ResolvableType;

class SpringFieldValueFactory
implements SingularFieldValueFactory,
Loggable {
    private static final Object NO_BEAN = new Object();
    private final ISupplier<ApplicationContext> contextLocator;
    private final ConcurrentMap<SpringBeanLocator, Object> cache = new ConcurrentHashMap<SpringBeanLocator, Object>();
    private final ConcurrentMap<AbstractMap.SimpleEntry<Class<?>, Class<?>>, String> beanNameCache = new ConcurrentHashMap();
    private final boolean wrapInProxies;

    public SpringFieldValueFactory() {
        this(ApplicationContextProvider.supplier(), true);
    }

    public SpringFieldValueFactory(@Nonnull ISupplier<ApplicationContext> contextLocator) {
        this(contextLocator, true);
    }

    public SpringFieldValueFactory(@Nonnull ISupplier<ApplicationContext> contextLocator, boolean wrapInProxies) {
        this.contextLocator = Objects.requireNonNull(contextLocator);
        this.wrapInProxies = wrapInProxies;
    }

    @Nonnull
    public FieldInjectionInfo createCachedInfo(@Nonnull Field field) {
        return new FieldInjectionInfoSpring(field);
    }

    @Nullable
    public Object getFieldValue(@Nonnull FieldInjectionInfo fieldInfo, @Nonnull Object fieldOwner) {
        FieldInjectionInfoSpring springFieldInfo = (FieldInjectionInfoSpring)fieldInfo;
        Object cachedValue = springFieldInfo.getCachedValue();
        if (cachedValue != null) {
            return cachedValue == NO_BEAN ? null : cachedValue;
        }
        SpringBeanLocator locator = this.resolveLocator(springFieldInfo);
        cachedValue = this.cache.get(locator);
        if (cachedValue != null) {
            return cachedValue == NO_BEAN ? null : cachedValue;
        }
        Object target = null;
        try {
            target = locator.locateProxyTarget();
        }
        catch (IllegalStateException isx) {
            this.getLogger().trace(isx.getMessage(), (Throwable)isx);
        }
        if (target == null) {
            this.cache.put(locator, NO_BEAN);
            springFieldInfo.setCachedValue(NO_BEAN);
            return null;
        }
        if (this.wrapInProxies) {
            target = LazyInitProxyFactory.createProxy(fieldInfo.getType(), locator);
        }
        if (locator.isSingletonBean()) {
            this.cache.put(locator, target);
            springFieldInfo.setCachedValue(target);
        }
        return target;
    }

    @Nonnull
    private SpringBeanLocator resolveLocator(@Nonnull FieldInjectionInfoSpring fieldInfo) {
        SpringBeanLocator locator = fieldInfo.getLocator();
        if (locator == null) {
            String beanName = this.getBeanName(fieldInfo);
            locator = new SpringBeanLocator(beanName, fieldInfo.getType(), this.contextLocator);
            fieldInfo.setLocator(locator);
        }
        return locator;
    }

    private String getBeanName(@Nonnull FieldInjectionInfo fieldInfo) {
        String name = fieldInfo.getBeanName();
        if (StringUtils.isBlank((CharSequence)name)) {
            Class generic = ResolvableType.forType((Type)fieldInfo.getType()).resolveGeneric(new int[]{0});
            Class fieldType = fieldInfo.getType();
            AbstractMap.SimpleEntry<Class, Class> keyPair = new AbstractMap.SimpleEntry<Class, Class>(fieldType, generic);
            name = (String)this.beanNameCache.get(keyPair);
            if (name == null && (name = this.getBeanNameOfClass(fieldInfo, fieldType, generic)) != null) {
                this.beanNameCache.put(keyPair, name);
            }
        }
        return name;
    }

    private String getBeanNameOfClass(FieldInjectionInfo fieldInfo, Class<?> clazz, Class<?> generic) {
        ApplicationContext ctx = (ApplicationContext)this.contextLocator.get();
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)ctx, clazz)));
        if (ctx instanceof AbstractApplicationContext) {
            names.removeIf(s -> {
                if (BeanFactoryUtils.isFactoryDereference((String)s) || s.startsWith("scopedTarget.")) {
                    return true;
                }
                BeanDefinition beanDef = this.getBeanDefinition(((AbstractApplicationContext)ctx).getBeanFactory(), (String)s);
                return beanDef != null && !beanDef.isAutowireCandidate();
            });
        }
        if (names.size() > 1) {
            return this.selectOneName(fieldInfo, clazz, generic, ctx, names);
        }
        if (!names.isEmpty()) {
            return (String)names.get(0);
        }
        return null;
    }

    @Nullable
    private String selectOneName(FieldInjectionInfo fieldInfo, Class<?> clazz, Class<?> generic, ApplicationContext ctx, @Nonnull List<String> names) {
        int nameIndex;
        if (ctx instanceof AbstractApplicationContext) {
            ArrayList<String> primaries = new ArrayList<String>();
            for (String name : names) {
                BeanDefinition beanDef = this.getBeanDefinition(((AbstractApplicationContext)ctx).getBeanFactory(), name);
                if (!(beanDef instanceof AbstractBeanDefinition) || !beanDef.isPrimary()) continue;
                primaries.add(name);
            }
            if (primaries.size() == 1) {
                return (String)primaries.get(0);
            }
        }
        if ((nameIndex = names.indexOf(fieldInfo.getFieldName())) > -1) {
            return names.get(nameIndex);
        }
        if (generic != null) {
            return null;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("More than one bean of type [");
        msg.append(clazz.getName());
        msg.append("] found, you have to specify the name of the bean ");
        msg.append("(@SpringBean(name=\"foo\")) or (@Named(\"foo\") if using @javax.inject classes) in order to resolve this conflict. ");
        msg.append("Matched beans: ");
        msg.append(names.stream().collect(Collectors.joining(",")));
        throw new SingularInjectionException(fieldInfo, null, (CharSequence)msg, null);
    }

    public BeanDefinition getBeanDefinition(ConfigurableListableBeanFactory beanFactory, String name) {
        ConfigurableListableBeanFactory current = beanFactory;
        while (current != null) {
            if (current.containsBeanDefinition(name)) {
                return current.getBeanDefinition(name);
            }
            BeanFactory parent = beanFactory.getParentBeanFactory();
            current = parent instanceof ConfigurableListableBeanFactory ? (ConfigurableListableBeanFactory)parent : null;
        }
        return null;
    }

    private static class FieldInjectionInfoSpring
    extends FieldInjectionInfo {
        private SpringBeanLocator locator;
        private Object cachedValue;

        public FieldInjectionInfoSpring(Field field) {
            super(field);
        }

        public SpringBeanLocator getLocator() {
            return this.locator;
        }

        public void setLocator(SpringBeanLocator locator) {
            this.locator = locator;
        }

        public void setCachedValue(Object cachedValue) {
            this.cachedValue = cachedValue;
        }

        public Object getCachedValue() {
            return this.cachedValue;
        }
    }
}

