/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.support.persistence;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.persistence.Transient;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.list.dsl.MirrorList;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.support.persistence.SimpleDAO;
import org.opensingular.lib.support.persistence.entity.BaseEntity;

public class BaseDAO<T extends BaseEntity, ID extends Serializable>
extends SimpleDAO {
    protected Class<T> entityClass;

    public BaseDAO(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public ID save(T newEntity) {
        return (ID)this.getSession().save(newEntity);
    }

    public void saveOrUpdate(T newEntity) {
        this.getSession().saveOrUpdate(newEntity);
    }

    @Nonnull
    public Optional<T> get(@Nonnull ID id) {
        Objects.requireNonNull(id);
        return Optional.ofNullable((BaseEntity)this.getSession().get(this.entityClass, id));
    }

    public T getOrException(@Nonnull ID id) {
        Optional<T> result = this.get(id);
        if (result.isPresent()) {
            return (T)((BaseEntity)result.get());
        }
        throw SingularException.rethrow((String)("N\u00e3o foi encontrado a entidade " + this.entityClass.getName() + " com ID=" + id));
    }

    @Nonnull
    public Optional<T> find(@Nonnull ID id) {
        Objects.requireNonNull(id);
        return Optional.ofNullable((BaseEntity)this.getSession().createCriteria(this.entityClass).add(Restrictions.idEq(id)).uniqueResult());
    }

    @Nonnull
    public T findOrException(@Nonnull ID id) {
        Optional<T> result = this.find((Serializable)Objects.requireNonNull(id));
        if (result.isPresent()) {
            return (T)((BaseEntity)result.get());
        }
        throw SingularException.rethrow((String)("N\u00e3o foi encontrado a entidade " + this.entityClass.getName() + " com ID=" + id));
    }

    public List<T> listAll() {
        return this.getSession().createCriteria(this.entityClass).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).list();
    }

    public T merge(T newEntity) {
        return (T)((BaseEntity)this.getSession().merge(newEntity));
    }

    public void delete(T obj) {
        this.getSession().delete(obj);
    }

    public void evict(Object o) {
        this.getSession().evict(o);
    }

    public List<T> findByProperty(String propertyName, String value) {
        return this.findByProperty(propertyName, value, null, null);
    }

    public <T> List<T> findByProperty(String propertyName, String value, Integer maxResults) {
        return this.findByProperty(propertyName, value, null, maxResults);
    }

    public <T> T findByUniqueProperty(String propertyName, Object value) {
        return (T)this.getSession().createCriteria(this.entityClass).add((Criterion)Restrictions.eq((String)propertyName, (Object)value)).setMaxResults(1).uniqueResult();
    }

    public <T> List<T> findByExample(T filter) {
        return this.findByExample(filter, null);
    }

    public <T> List<T> findByExample(T filter, Integer maxResults) {
        try {
            Criteria criteria = this.getSession().createCriteria(this.entityClass);
            MirrorList properties = new Mirror().on(this.entityClass).reflectAll().fields();
            for (Field f : properties) {
                Object value;
                f.setAccessible(true);
                if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(Transient.class) || (value = f.get(filter)) == null) continue;
                criteria.add((Criterion)Restrictions.eq((String)f.getName(), (Object)value));
            }
            if (maxResults != null) {
                criteria.setMaxResults(maxResults.intValue());
            }
            return criteria.list();
        }
        catch (IllegalAccessException e) {
            throw SingularException.rethrow((String)e.getMessage(), (Throwable)e);
        }
    }

    public <T> List<T> findByProperty(String propertyName, String value, MatchMode matchMode, Integer maxResults) {
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        if (value != null && !value.isEmpty()) {
            MatchMode mode = matchMode == null ? MatchMode.EXACT : matchMode;
            criteria.add(Restrictions.ilike((String)propertyName, (String)value, (MatchMode)mode));
        }
        if (maxResults != null) {
            criteria.setMaxResults(maxResults.intValue());
        }
        return criteria.list();
    }

    protected static final <K> Optional<K> findUniqueResult(Class<K> expectedResultClass, Criteria criteria) {
        Object result = criteria.setMaxResults(1).uniqueResult();
        return Optional.ofNullable(expectedResultClass.cast(result));
    }

    protected static final <K> Optional<K> findUniqueResult(Class<K> expectedResultClass, Query query) {
        Object result = query.setMaxResults(1).uniqueResult();
        return Optional.ofNullable(expectedResultClass.cast(result));
    }

    public void flush() {
        this.getSession().flush();
    }
}

