/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.support.persistence.util;

import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.SequenceIdentityGenerator;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.type.Type;
import org.opensingular.lib.commons.base.SingularProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridIdentityOrSequenceGenerator
implements PostInsertIdentifierGenerator,
Configurable,
BulkInsertionCapableIdentifierGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ENTITY = "entity_name";
    private static final String SEQUENCE = "sequence";
    public static final String CLASS_NAME = "org.opensingular.lib.support.persistence.util.HybridIdentityOrSequenceGenerator";
    private PostInsertIdentifierGenerator delegate;

    private PostInsertIdentifierGenerator getDelegate() {
        if (this.delegate == null) {
            String generator = SingularProperties.getOpt((String)"flow.persistence.hibernate.generator").orElse(null);
            if (SEQUENCE.equals(generator)) {
                this.delegate = new SequenceIdentityGenerator();
            } else if ("identity".equals(generator)) {
                this.delegate = new IdentityGenerator();
            } else {
                this.delegate = new IdentityGenerator();
                this.logger.warn("Tipo de gerador n\u00e3o definido (system property 'singular.hibernate.generator'), utilizando IdentityGenerator. ");
            }
        }
        return this.delegate;
    }

    public InsertGeneratedIdentifierDelegate getInsertGeneratedIdentifierDelegate(PostInsertIdentityPersister persister, Dialect dialect, boolean isGetGeneratedKeysEnabled) throws HibernateException {
        return this.getDelegate().getInsertGeneratedIdentifierDelegate(persister, dialect, isGetGeneratedKeysEnabled);
    }

    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        return this.getDelegate().generate(session, object);
    }

    public void configure(Type type, Properties params, Dialect d) throws MappingException {
        if (this.getDelegate() instanceof Configurable) {
            String key = String.format("flow.persistence.%s.sequence", params.getProperty(ENTITY, ""));
            Optional value = SingularProperties.getOpt((String)key);
            if (value.isPresent()) {
                params.setProperty(SEQUENCE, (String)value.get());
            } else {
                this.logger.warn("Property {} n\u00e3o foi definida.  Utilizando nome default de sequence do hibernate. ", (Object)key);
            }
            ((Configurable)this.getDelegate()).configure(type, params, d);
        }
    }

    public boolean supportsBulkInsertionIdentifierGeneration() {
        if (this.getDelegate() instanceof BulkInsertionCapableIdentifierGenerator) {
            return ((BulkInsertionCapableIdentifierGenerator)this.getDelegate()).supportsBulkInsertionIdentifierGeneration();
        }
        return false;
    }

    public String determineBulkInsertionIdentifierGenerationSelectFragment(Dialect dialect) {
        if (this.getDelegate() instanceof BulkInsertionCapableIdentifierGenerator) {
            return ((BulkInsertionCapableIdentifierGenerator)this.getDelegate()).determineBulkInsertionIdentifierGenerationSelectFragment(dialect);
        }
        return null;
    }
}

