/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.support.spring.security;

import java.util.Collection;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.support.spring.security.RestUserDetailsService;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class DefaultRestUserDetailsService
implements RestUserDetailsService {
    public static final String SUBJECT_PRINCIPAL_REGEX = "CN=(.*?)(?:,|$)";

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        if (this.getAllowedCommonName().equals(username)) {
            return this.createUserDetails(username);
        }
        throw new UsernameNotFoundException("N\u00e3o foi possivel autenticar o certificado informado");
    }

    protected UserDetails createUserDetails(String username) {
        return new User(username, "", (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"ROLE_USER"));
    }

    @Override
    public String getSubjectPrincipalRegex() {
        return SUBJECT_PRINCIPAL_REGEX;
    }

    protected String getAllowedCommonName() {
        return SingularProperties.get().getProperty("singular.rest.allowed.common.name", "");
    }
}

