/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.support.spring.util;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Named;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.context.SingularContext;
import org.opensingular.lib.commons.context.SingularSingletonStrategy;
import org.opensingular.lib.commons.lambda.IFunction;
import org.opensingular.lib.commons.lambda.ISupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Named
@Order(value=0)
@Lazy(value=false)
public class ApplicationContextProvider
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationContextProvider.class);
    private static final ISupplier<ApplicationContext> SUPPLIER = (ISupplier & Serializable)() -> ApplicationContextProvider.get();

    public static synchronized ApplicationContext getApplicationContext() {
        return (ApplicationContext)((SingularSingletonStrategy)SingularContext.get()).get(ApplicationContext.class);
    }

    public synchronized void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ((SingularSingletonStrategy)SingularContext.get()).singletonize(ApplicationContext.class, () -> applicationContext);
    }

    public static ApplicationContext get() {
        if (!ApplicationContextProvider.isConfigured()) {
            throw SingularException.rethrow((String)("O getApplicationContext() ainda n\u00e3o foi configurado em " + ApplicationContextProvider.class.getName()));
        }
        return ApplicationContextProvider.getApplicationContext();
    }

    public static boolean isConfigured() {
        return ((SingularSingletonStrategy)SingularContext.get()).exists(ApplicationContext.class);
    }

    public static ISupplier<ApplicationContext> supplier() {
        return SUPPLIER;
    }

    public static <T> ISupplier<T> supplierOf(IFunction<ApplicationContext, T> factory) {
        return (ISupplier & Serializable)() -> factory.apply((Object)ApplicationContextProvider.get());
    }

    public static <T> ISupplier<T> supplierOf(Class<T> beanClass) {
        return (ISupplier & Serializable)() -> ApplicationContextProvider.get().getBean(beanClass);
    }

    public static <T> ISupplier<Optional<T>> supplierOfOptional(Class<T> beanClass) {
        return (ISupplier & Serializable)() -> {
            try {
                Optional.of(ApplicationContextProvider.get().getBean(beanClass));
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return Optional.empty();
        };
    }

    @Nonnull
    public static <T> Optional<T> getBeanOpt(@Nonnull String name, @Nonnull Class<T> targetClass) {
        try {
            return Optional.ofNullable(ApplicationContextProvider.get().getBean(name, targetClass));
        }
        catch (NoSuchBeanDefinitionException ex) {
            LOGGER.debug(null, (Throwable)ex);
            return Optional.empty();
        }
    }

    @Nonnull
    public static <T> Optional<T> getBeanOpt(@Nonnull Class<T> targetClass) {
        try {
            return Optional.ofNullable(ApplicationContextProvider.get().getBean(targetClass));
        }
        catch (NoSuchBeanDefinitionException ex) {
            LOGGER.debug(null, (Throwable)ex);
            return Optional.empty();
        }
    }

    @Nonnull
    public static <T> Optional<T> getBeanOpt(@Nonnull String name) {
        try {
            return Optional.ofNullable(ApplicationContextProvider.get().getBean(name));
        }
        catch (NoSuchBeanDefinitionException ex) {
            LOGGER.debug(null, (Throwable)ex);
            return Optional.empty();
        }
    }

    @EventListener
    public void handleContextRefresh(ContextStartedEvent event) {
        this.setApplicationContext(event.getApplicationContext());
    }
}

