/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.support.spring;

import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.lib.commons.base.SingularException;
import org.springframework.beans.factory.NamedBean;

public class SpringUtils {
    private SpringUtils() {
    }

    @Nonnull
    public static String checkBeanName(@Nonnull NamedBean bean) {
        if (StringUtils.isBlank((CharSequence)bean.getBeanName())) {
            throw new SingularException("O nome do bean no spring n\u00e3o foi configurado para a classe " + bean.getClass().getName() + ". Verifique se o bean foi corretamente registrado no Spring antes de ser utilizado.");
        }
        return bean.getBeanName();
    }

    public static String erroMsg(NamedBean bean, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (bean.getBeanName() != null) {
            sb.append("bean=").append(bean.getBeanName()).append("; ");
        }
        sb.append("class=").append(bean.getClass()).append("]: ").append(msg);
        return sb.toString();
    }
}

