/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.support.spring.injection;

import com.google.common.collect.ImmutableSet;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Set;
import javax.annotation.Nonnull;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.opensingular.internal.lib.commons.injection.SingularInjectionException;
import org.opensingular.internal.lib.support.spring.injection.ILazyInitProxy;
import org.opensingular.internal.lib.support.spring.injection.IProxyTargetLocator;
import org.opensingular.internal.lib.support.spring.injection.ObjenesisProxyFactory;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.util.Loggable;

class LazyInitProxyFactory
implements Loggable {
    private static final Set<Class<?>> PRIMITIVES = ImmutableSet.of(String.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, (Object[])new Class[]{Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, Boolean.TYPE, Boolean.class});
    private static final int CGLIB_CALLBACK_NO_OVERRIDE = 0;
    private static final int CGLIB_CALLBACK_HANDLER = 1;
    private static final boolean IS_OBJENESIS_AVAILABLE = LazyInitProxyFactory.isObjenesisAvailable();

    LazyInitProxyFactory() {
    }

    public static Object createProxy(@Nonnull Class<?> type, @Nonnull IProxyTargetLocator locator) {
        try {
            if (PRIMITIVES.contains(type) || Enum.class.isAssignableFrom(type)) {
                return locator.locateProxyTarget();
            }
            if (type.isInterface()) {
                JdkHandler handler = new JdkHandler(type, locator);
                try {
                    return Proxy.newProxyInstance(LazyInitProxyFactory.resolveClassLoader(), new Class[]{type, Serializable.class, ILazyInitProxy.class, IWriteReplace.class}, (InvocationHandler)handler);
                }
                catch (IllegalArgumentException e) {
                    return Proxy.newProxyInstance(LazyInitProxyFactory.class.getClassLoader(), new Class[]{type, Serializable.class, ILazyInitProxy.class, IWriteReplace.class}, (InvocationHandler)handler);
                }
            }
            if (IS_OBJENESIS_AVAILABLE && (!LazyInitProxyFactory.hasNoArgConstructor(type) || LazyInitProxyFactory.hasFinalMethods(type))) {
                return ObjenesisProxyFactory.createProxy(type, locator, (NamingPolicy)SingularProxyNamingPolicy.INSTANCE);
            }
            CGLibInterceptor handler = new CGLibInterceptor(type, locator);
            Callback[] callbacks = new Callback[]{SerializableNoOpCallback.INSTANCE, handler};
            Enhancer e = new Enhancer();
            e.setClassLoader(LazyInitProxyFactory.resolveClassLoader());
            e.setInterfaces(new Class[]{Serializable.class, ILazyInitProxy.class, IWriteReplace.class});
            e.setSuperclass(type);
            e.setCallbackFilter(NoOpForProtectedMethodsCGLibCallbackFilter.INSTANCE);
            e.setCallbacks(callbacks);
            e.setNamingPolicy((NamingPolicy)SingularProxyNamingPolicy.SINGLETON);
            return e.create();
        }
        catch (Exception e) {
            throw new SingularInjectionException("Erro ao tentar criar proxy para a classe [" + type.getName() + ']', (Throwable)e);
        }
    }

    private static boolean hasFinalMethods(Class<?> type) {
        for (Method m : type.getDeclaredMethods()) {
            if (!Modifier.isFinal(m.getModifiers())) continue;
            return true;
        }
        return false;
    }

    private static ClassLoader resolveClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static boolean isEqualsMethod(Method method) {
        return method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class && "equals".equals(method.getName());
    }

    public static boolean isHashCodeMethod(Method method) {
        return method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0 && "hashCode".equals(method.getName());
    }

    public static boolean isToStringMethod(Method method) {
        return method.getReturnType() == String.class && method.getParameterTypes().length == 0 && "toString".equals(method.getName());
    }

    public static boolean isFinalizeMethod(Method method) {
        return method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 0 && "finalize".equals(method.getName());
    }

    public static boolean isWriteReplaceMethod(Method method) {
        return method.getReturnType() == Object.class && method.getParameterTypes().length == 0 && "writeReplace".equals(method.getName());
    }

    private static boolean hasNoArgConstructor(Class<?> type) {
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    private static boolean isObjenesisAvailable() {
        try {
            Class.forName("org.objenesis.ObjenesisStd");
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static final class SingularProxyNamingPolicy
    extends DefaultNamingPolicy {
        public static final SingularProxyNamingPolicy SINGLETON = new SingularProxyNamingPolicy();

        private SingularProxyNamingPolicy() {
        }

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return super.getClassName("SINGULAR_" + prefix, source, key, names);
        }
    }

    private static class JdkHandler
    implements InvocationHandler,
    ILazyInitProxy,
    Serializable,
    IWriteReplace,
    Loggable {
        private static final long serialVersionUID = 1L;
        private final IProxyTargetLocator locator;
        private final String typeName;
        private transient Object target;

        public JdkHandler(Class<?> type, IProxyTargetLocator locator) {
            this.locator = locator;
            this.typeName = type.getName();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (LazyInitProxyFactory.isFinalizeMethod(method)) {
                return null;
            }
            if (LazyInitProxyFactory.isEqualsMethod(method)) {
                return this.equals(args[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (LazyInitProxyFactory.isHashCodeMethod(method)) {
                return this.hashCode();
            }
            if (LazyInitProxyFactory.isToStringMethod(method)) {
                return this.toString();
            }
            if (method.getDeclaringClass().equals(ILazyInitProxy.class)) {
                return this.getProxyTarget();
            }
            if (LazyInitProxyFactory.isWriteReplaceMethod(method)) {
                return this.writeReplace();
            }
            if (this.target == null) {
                this.target = this.locator.locateProxyTarget();
            }
            try {
                method.setAccessible(true);
                return method.invoke(this.target, args);
            }
            catch (InvocationTargetException e) {
                this.getLogger().trace(e.getMessage(), (Throwable)e);
                if (e.getCause() instanceof Exception) {
                    throw e.getCause();
                }
                throw new SingularInjectionException(null, (Throwable)e);
            }
        }

        @Override
        public Object getProxyTarget() {
            return this.locator.locateProxyTarget();
        }

        @Override
        public Object writeReplace() throws ObjectStreamException {
            return new ProxyReplacement(this.typeName, this.locator);
        }
    }

    private static class NoOpForProtectedMethodsCGLibCallbackFilter
    implements CallbackFilter {
        private static final CallbackFilter INSTANCE = new NoOpForProtectedMethodsCGLibCallbackFilter();

        private NoOpForProtectedMethodsCGLibCallbackFilter() {
        }

        public int accept(Method method) {
            if (Modifier.isProtected(method.getModifiers())) {
                return 0;
            }
            return 1;
        }
    }

    public static class SerializableNoOpCallback
    implements NoOp,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final NoOp INSTANCE = new SerializableNoOpCallback();
    }

    protected static class CGLibInterceptor
    extends AbstractCGLibInterceptor {
        public CGLibInterceptor(Class<?> type, IProxyTargetLocator locator) {
            super(type, locator);
        }

        @Override
        public Object writeReplace() throws ObjectStreamException {
            return new ProxyReplacement(this.typeName, this.locator);
        }
    }

    public static abstract class AbstractCGLibInterceptor
    implements MethodInterceptor,
    ILazyInitProxy,
    Serializable,
    IWriteReplace {
        private static final long serialVersionUID = 1L;
        protected final IProxyTargetLocator locator;
        protected final String typeName;
        private transient Object target;

        public AbstractCGLibInterceptor(Class<?> type, IProxyTargetLocator locator) {
            this.typeName = type.getName();
            this.locator = locator;
        }

        public Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (LazyInitProxyFactory.isFinalizeMethod(method)) {
                return null;
            }
            if (LazyInitProxyFactory.isEqualsMethod(method)) {
                return this.equals(args[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (LazyInitProxyFactory.isHashCodeMethod(method)) {
                return this.hashCode();
            }
            if (LazyInitProxyFactory.isToStringMethod(method)) {
                return this.toString();
            }
            if (LazyInitProxyFactory.isWriteReplaceMethod(method)) {
                return this.writeReplace();
            }
            if (method.getDeclaringClass().equals(ILazyInitProxy.class)) {
                return this.getProxyTarget();
            }
            if (this.target == null) {
                this.target = this.locator.locateProxyTarget();
            }
            return proxy.invoke(this.target, args);
        }

        @Override
        public Object getProxyTarget() {
            return this.locator.locateProxyTarget();
        }
    }

    static class ProxyReplacement
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IProxyTargetLocator locator;
        private final String type;

        public ProxyReplacement(String type, IProxyTargetLocator locator) {
            this.type = type;
            this.locator = locator;
        }

        public Object readResolve() {
            Class<?> clazz;
            try {
                clazz = Class.forName(this.type, false, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                throw SingularException.rethrow((String)("Could not resolve type [" + this.type + "]"), (Throwable)e);
            }
            return LazyInitProxyFactory.createProxy(clazz, this.locator);
        }
    }

    public static interface IWriteReplace {
        public Object writeReplace() throws ObjectStreamException;
    }
}

