/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.support.spring.injection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensingular.internal.lib.commons.injection.SingularFieldValueFactory;
import org.opensingular.internal.lib.commons.injection.SingularInjectionException;
import org.opensingular.internal.lib.commons.injection.SingularInjector;
import org.opensingular.internal.lib.commons.injection.SingularInjectorImpl;
import org.opensingular.internal.lib.commons.injection.SingularInjectorProxy;
import org.opensingular.internal.lib.support.spring.injection.SpringFieldValueFactory;
import org.opensingular.lib.commons.lambda.ISupplier;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SingularSpringInjector {
    private SingularSpringInjector() {
    }

    @Nonnull
    public static SingularInjector get() {
        if (ApplicationContextProvider.isConfigured()) {
            return SingularSpringInjector.get(ApplicationContextProvider.supplier());
        }
        return new SingularSpringInjectorProxy();
    }

    @Nonnull
    public static SingularInjector get(@Nonnull ISupplier<ApplicationContext> ctxSupplier) {
        SingularInjector injector;
        ApplicationContext ctx = (ApplicationContext)ctxSupplier.get();
        try {
            injector = (SingularInjector)ctx.getBean(SingularInjector.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            injector = null;
        }
        if (injector == null) {
            injector = new SingularInjectorImpl((SingularFieldValueFactory)new SpringFieldValueFactory(ctxSupplier));
            if (ctx instanceof ConfigurableApplicationContext) {
                ConfigurableApplicationContext ctxConfigurable = (ConfigurableApplicationContext)ctx;
                ctxConfigurable.getBeanFactory().registerSingleton(SingularInjector.class.getName(), (Object)injector);
            } else {
                throw new SingularInjectionException("O applicationContext passado [" + ctx.getClass().getName() + "] n\u00e3o implementa " + ConfigurableApplicationContext.class.getName());
            }
        }
        return injector;
    }

    static final class SingularSpringInjectorProxy
    extends SingularInjectorProxy {
        SingularSpringInjectorProxy() {
        }

        @Nullable
        protected SingularInjector findInjectorIfAvailable() {
            if (ApplicationContextProvider.isConfigured()) {
                return SingularSpringInjector.get(ApplicationContextProvider.supplier());
            }
            return null;
        }
    }
}

