/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.support.spring.injection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensingular.internal.lib.commons.injection.SingularInjectionException;
import org.opensingular.internal.lib.support.spring.injection.FieldBeansCollector;
import org.opensingular.internal.lib.support.spring.injection.IProxyTargetLocator;
import org.opensingular.lib.commons.lambda.ISupplier;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.ResolvableType;

class SpringBeanLocator
implements IProxyTargetLocator {
    private static final long serialVersionUID = 1L;
    private transient WeakReference<Class<?>> beanTypeCache;
    private final String beanTypeName;
    private String beanName;
    private ISupplier<ApplicationContext> springContextLocator;
    private Boolean singletonCache = null;
    private ResolvableType fieldResolvableType;
    private ResolvableType fieldElementsResolvableType;

    public SpringBeanLocator(@Nullable String beanName, @Nonnull Class<?> beanType, @Nonnull ISupplier<ApplicationContext> locator) {
        Objects.requireNonNull(locator, "locator");
        Objects.requireNonNull(beanType, "beanType");
        this.beanName = beanName;
        this.beanTypeCache = new WeakReference(beanType);
        this.beanTypeName = beanType.getName();
        this.springContextLocator = locator;
        this.fieldResolvableType = ResolvableType.forType(beanType);
        this.fieldElementsResolvableType = SpringBeanLocator.extractElementGeneric(this.fieldResolvableType);
    }

    private static ResolvableType extractElementGeneric(ResolvableType fieldResolvableType) {
        Class clazz = fieldResolvableType.resolve();
        if (Set.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz)) {
            return fieldResolvableType.getGeneric(new int[0]);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return fieldResolvableType.getGeneric(new int[]{1});
        }
        return null;
    }

    public boolean isSingletonBean() {
        if (this.singletonCache == null) {
            this.singletonCache = this.getBeanName() != null && this.getSpringContext().isSingleton(this.getBeanName());
        }
        return this.singletonCache;
    }

    public Class<?> getBeanType() {
        Class<?> clazz;
        Class<?> clazz2 = clazz = this.beanTypeCache == null ? null : (Class<?>)this.beanTypeCache.get();
        if (clazz == null) {
            try {
                clazz = Class.forName(this.beanTypeName, false, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                throw new SingularInjectionException("SpringBeanLocator could not find class [" + this.beanTypeName + "] needed to locate the [" + (this.beanName != null ? this.beanName : "bean name not specified") + "] bean", (Throwable)e);
            }
            this.beanTypeCache = new WeakReference(clazz);
        }
        return clazz;
    }

    @Override
    public Object locateProxyTarget() {
        return this.lookupSpringBean(this.getSpringContext(), this.beanName, this.getBeanType());
    }

    @Nonnull
    private ApplicationContext getSpringContext() {
        ApplicationContext context = (ApplicationContext)this.springContextLocator.get();
        if (context == null) {
            throw new SingularInjectionException("spring application context locator returned null");
        }
        return context;
    }

    public final String getBeanName() {
        return this.beanName;
    }

    private Object lookupSpringBean(ApplicationContext ctx, String name, Class<?> clazz) {
        try {
            if (name != null) {
                return ctx.getBean(name, clazz);
            }
            Class lookupClass = this.fieldElementsResolvableType != null ? this.fieldElementsResolvableType.resolve() : clazz;
            List<String> names = this.loadBeanNames(ctx, lookupClass);
            return this.getBeansByName(ctx, names);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    private List<String> loadBeanNames(ApplicationContext ctx, Class<?> lookupClass) {
        ArrayList<String> beanNames = new ArrayList<String>();
        Class<?> fieldType = this.getBeanType();
        String[] beanNamesArr = ctx.getBeanNamesForType(fieldType);
        beanNames.addAll(Arrays.asList(beanNamesArr));
        if (lookupClass != fieldType) {
            beanNamesArr = ctx.getBeanNamesForType(lookupClass);
            beanNames.addAll(Arrays.asList(beanNamesArr));
        }
        beanNames.removeIf(s -> !ctx.containsBeanDefinition(s));
        return beanNames;
    }

    private Object getBeansByName(ApplicationContext ctx, List<String> names) {
        FieldBeansCollector beansCollector = new FieldBeansCollector(this.fieldResolvableType);
        for (String beanName : names) {
            boolean elementMatch;
            RootBeanDefinition beanDef = this.getBeanDefinition(ctx, beanName);
            if (beanDef == null) continue;
            ResolvableType candidateResolvableType = null;
            if (beanDef.hasBeanClass()) {
                candidateResolvableType = ResolvableType.forClass((Class)beanDef.getBeanClass());
            } else if (beanDef.getResolvedFactoryMethod() != null) {
                candidateResolvableType = ResolvableType.forMethodReturnType((Method)beanDef.getResolvedFactoryMethod());
            }
            if (candidateResolvableType == null) continue;
            boolean exactMatch = this.fieldResolvableType.isAssignableFrom(candidateResolvableType);
            boolean bl = elementMatch = this.fieldElementsResolvableType != null && this.fieldElementsResolvableType.isAssignableFrom(candidateResolvableType);
            if (exactMatch) {
                this.beanName = beanName;
                return ctx.getBean(beanName);
            }
            if (!elementMatch) continue;
            beansCollector.addBean(beanName, ctx.getBean(beanName));
        }
        return beansCollector.getBeansToInject();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SpringBeanLocator) {
            SpringBeanLocator other = (SpringBeanLocator)obj;
            return this.beanTypeName.equals(other.beanTypeName) && Objects.equals(this.beanName, other.beanName);
        }
        return false;
    }

    public int hashCode() {
        int hashcode = this.beanTypeName.hashCode();
        if (this.getBeanName() != null) {
            hashcode += 127 * this.beanName.hashCode();
        }
        return hashcode;
    }

    public RootBeanDefinition getBeanDefinition(ApplicationContext ctx, String name) {
        BeanDefinition beanDef;
        ConfigurableListableBeanFactory beanFactory = ((AbstractApplicationContext)ctx).getBeanFactory();
        BeanDefinition beanDefinition = beanDef = beanFactory.containsBean(name) ? beanFactory.getMergedBeanDefinition(name) : null;
        if (beanDef instanceof RootBeanDefinition) {
            return (RootBeanDefinition)beanDef;
        }
        return null;
    }
}

