/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.context.spring;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.opensingular.internal.lib.commons.injection.SingularInjector;
import org.opensingular.internal.lib.support.spring.injection.SingularSpringInjector;
import org.opensingular.lib.commons.context.DefaultServiceRegistry;
import org.opensingular.lib.commons.context.RefService;
import org.opensingular.lib.commons.context.ServiceRegistry;
import org.opensingular.lib.commons.context.ServiceRegistryLocator;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.springframework.context.annotation.Lazy;

@Lazy(value=false)
public class SpringServiceRegistry
implements ServiceRegistry,
Loggable {
    private SingularInjector injector;
    private DefaultServiceRegistry delegate = new DefaultServiceRegistry(){};

    @PostConstruct
    public void init() {
        ServiceRegistryLocator.setup((ServiceRegistry)this);
    }

    @Nonnull
    public <T> Optional<T> lookupService(@Nonnull String name, @Nonnull Class<T> targetClass) {
        Optional<T> service = this.delegate.lookupService(name, targetClass);
        if (!service.isPresent()) {
            service = ApplicationContextProvider.getBeanOpt(name, targetClass);
        }
        return service;
    }

    @Nonnull
    public <T> Optional<T> lookupService(@Nonnull Class<T> targetClass) {
        Optional<T> service = this.delegate.lookupService(targetClass);
        if (!service.isPresent()) {
            service = ApplicationContextProvider.getBeanOpt(targetClass);
        }
        return service;
    }

    @Nonnull
    public <T> Optional<T> lookupService(@Nonnull String name) {
        Optional service = this.delegate.lookupService(name);
        if (!service.isPresent()) {
            service = ApplicationContextProvider.getBeanOpt(name);
        }
        return service;
    }

    @Nonnull
    public SingularInjector lookupSingularInjector() {
        if (this.injector == null) {
            this.injector = SingularSpringInjector.get();
        }
        return this.injector;
    }

    @Nonnull
    public Map<String, ServiceRegistry.ServiceEntry> services() {
        return this.delegate.services();
    }

    public <T> void bindService(Class<T> registerClass, RefService<? extends T> provider) {
        this.delegate.bindService(registerClass, provider);
    }

    public <T> void bindService(String serviceName, Class<T> registerClass, RefService<? extends T> provider) {
        this.delegate.bindService(serviceName, registerClass, provider);
    }
}

