/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.support.persistence;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.opensingular.lib.commons.util.Loggable;

public class JTDSHibernateDataSourceWrapper
implements DataSource,
Loggable {
    private DataSource dataSource;

    public JTDSHibernateDataSourceWrapper(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JTDSHibernateDataSourceWrapper() {
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.proxyConnection(this.dataSource.getConnection());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.proxyConnection(this.dataSource.getConnection(username, password));
    }

    private Connection proxyConnection(Connection connection) {
        return (Connection)Proxy.newProxyInstance(connection.getClass().getClassLoader(), new Class[]{Connection.class}, (proxy, method, args) -> {
            Object invoke = method.invoke((Object)connection, args);
            if ("prepareStatement".equals(method.getName())) {
                return this.createPreparedStatementProxy(invoke);
            }
            return invoke;
        });
    }

    private Object createPreparedStatementProxy(Object invoke) {
        return Proxy.newProxyInstance(invoke.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (proxy1, method1, args1) -> {
            Arguments arguments = new Arguments(args1);
            if ("setBinaryStream".equals(method1.getName()) && arguments.isCollectParameters()) {
                PreparedStatement ps = (PreparedStatement)invoke;
                ps.setBinaryStream((int)((Integer)arguments.getFirst()), (InputStream)arguments.getSecound(), ((Long)arguments.getThird()).intValue());
                return null;
            }
            if ("setCharacterStream".equals(method1.getName()) && arguments.isCollectParameters()) {
                PreparedStatement ps = (PreparedStatement)invoke;
                ps.setCharacterStream((int)((Integer)arguments.getFirst()), (Reader)arguments.getSecound(), ((Long)arguments.getThird()).intValue());
                return null;
            }
            return method1.invoke(invoke, args1);
        });
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    static class Arguments {
        private static final int FIRST = 0;
        private static final int SECOUND = 1;
        private static final int THIRD = 2;
        private final Object[] args;

        Arguments(Object[] args) {
            this.args = args;
        }

        Object getFirst() {
            return this.getAtIndex(0);
        }

        Object getSecound() {
            return this.getAtIndex(1);
        }

        Object getThird() {
            return this.getAtIndex(2);
        }

        Object getAtIndex(int index) {
            if (this.args.length > index) {
                return this.args[index];
            }
            return null;
        }

        private boolean isCollectParameters() {
            return this.args != null && this.args.length == 3 && this.getAtIndex(2) instanceof Long;
        }
    }
}

