/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.support.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.EmptyInterceptor;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.support.persistence.DatabaseObjectNameReplacement;

public class SingularEntityInterceptor
extends EmptyInterceptor {
    private List<DatabaseObjectNameReplacement> schemaReplacements = new ArrayList<DatabaseObjectNameReplacement>();

    public SingularEntityInterceptor(List<DatabaseObjectNameReplacement> replacements) {
        Optional schemaName = SingularProperties.getOpt((String)"singular.custom.schema.name");
        schemaName.ifPresent(s -> this.schemaReplacements.add(new DatabaseObjectNameReplacement("DBSINGULAR", (String)s)));
        this.schemaReplacements.addAll(replacements);
    }

    public SingularEntityInterceptor() {
        this(Collections.EMPTY_LIST);
    }

    public String onPrepareStatement(String sql) {
        StringBuilder result = new StringBuilder(sql);
        for (DatabaseObjectNameReplacement schemaReplacement : this.schemaReplacements) {
            Pattern p = Pattern.compile(Pattern.quote(schemaReplacement.getOriginalObjectName()));
            Matcher m = p.matcher(result);
            int start = 0;
            while (m.find(start)) {
                result.replace(m.start(), m.end(), schemaReplacement.getObjectNameReplacement());
                start = m.start() + schemaReplacement.getObjectNameReplacement().length();
            }
        }
        return result.toString();
    }
}

